/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import tech.deplant.java4ever.binding.AppSigningBox;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Crypto {
    public static ResultOfFactorize factorize(EverSdkContext ctx, String composite) throws EverSdkException {
        return ctx.call("crypto.factorize", new ParamsOfFactorize(composite), ResultOfFactorize.class);
    }

    public static ResultOfModularPower modularPower(EverSdkContext ctx, String base, String exponent, String modulus) throws EverSdkException {
        return ctx.call("crypto.modular_power", new ParamsOfModularPower(base, exponent, modulus), ResultOfModularPower.class);
    }

    public static ResultOfTonCrc16 tonCrc16(EverSdkContext ctx, String data) throws EverSdkException {
        return ctx.call("crypto.ton_crc16", new ParamsOfTonCrc16(data), ResultOfTonCrc16.class);
    }

    public static ResultOfGenerateRandomBytes generateRandomBytes(EverSdkContext ctx, Integer length) throws EverSdkException {
        return ctx.call("crypto.generate_random_bytes", new ParamsOfGenerateRandomBytes(length), ResultOfGenerateRandomBytes.class);
    }

    public static ResultOfConvertPublicKeyToTonSafeFormat convertPublicKeyToTonSafeFormat(EverSdkContext ctx, String publicKey) throws EverSdkException {
        return ctx.call("crypto.convert_public_key_to_ton_safe_format", new ParamsOfConvertPublicKeyToTonSafeFormat(publicKey), ResultOfConvertPublicKeyToTonSafeFormat.class);
    }

    public static KeyPair generateRandomSignKeys(EverSdkContext ctx) throws EverSdkException {
        return ctx.call("crypto.generate_random_sign_keys", null, KeyPair.class);
    }

    public static ResultOfSign sign(EverSdkContext ctx, String unsigned, KeyPair keys) throws EverSdkException {
        return ctx.call("crypto.sign", new ParamsOfSign(unsigned, keys), ResultOfSign.class);
    }

    public static ResultOfVerifySignature verifySignature(EverSdkContext ctx, String signed, @JsonProperty(value="public") String publicKey) throws EverSdkException {
        return ctx.call("crypto.verify_signature", new ParamsOfVerifySignature(signed, publicKey), ResultOfVerifySignature.class);
    }

    public static ResultOfHash sha256(EverSdkContext ctx, String data) throws EverSdkException {
        return ctx.call("crypto.sha256", new ParamsOfHash(data), ResultOfHash.class);
    }

    public static ResultOfHash sha512(EverSdkContext ctx, String data) throws EverSdkException {
        return ctx.call("crypto.sha512", new ParamsOfHash(data), ResultOfHash.class);
    }

    public static ResultOfScrypt scrypt(EverSdkContext ctx, String password, String salt, Integer logN, Integer r, Integer p, Integer dkLen) throws EverSdkException {
        return ctx.call("crypto.scrypt", new ParamsOfScrypt(password, salt, logN, r, p, dkLen), ResultOfScrypt.class);
    }

    public static KeyPair naclSignKeypairFromSecretKey(EverSdkContext ctx, @JsonProperty(value="secret") String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_keypair_from_secret_key", new ParamsOfNaclSignKeyPairFromSecret(secretKey), KeyPair.class);
    }

    public static ResultOfNaclSign naclSign(EverSdkContext ctx, String unsigned, @JsonProperty(value="secret") String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign", new ParamsOfNaclSign(unsigned, secretKey), ResultOfNaclSign.class);
    }

    public static ResultOfNaclSignOpen naclSignOpen(EverSdkContext ctx, String signed, @JsonProperty(value="public") String publicKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_open", new ParamsOfNaclSignOpen(signed, publicKey), ResultOfNaclSignOpen.class);
    }

    public static ResultOfNaclSignDetached naclSignDetached(EverSdkContext ctx, String unsigned, @JsonProperty(value="secret") String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_detached", new ParamsOfNaclSign(unsigned, secretKey), ResultOfNaclSignDetached.class);
    }

    public static ResultOfNaclSignDetachedVerify naclSignDetachedVerify(EverSdkContext ctx, String unsigned, String signature, @JsonProperty(value="public") String publicKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_detached_verify", new ParamsOfNaclSignDetachedVerify(unsigned, signature, publicKey), ResultOfNaclSignDetachedVerify.class);
    }

    public static KeyPair naclBoxKeypair(EverSdkContext ctx) throws EverSdkException {
        return ctx.call("crypto.nacl_box_keypair", null, KeyPair.class);
    }

    public static KeyPair naclBoxKeypairFromSecretKey(EverSdkContext ctx, @JsonProperty(value="secret") String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_box_keypair_from_secret_key", new ParamsOfNaclBoxKeyPairFromSecret(secretKey), KeyPair.class);
    }

    public static ResultOfNaclBox naclBox(EverSdkContext ctx, String decrypted, String nonce, String theirPublic, @JsonProperty(value="secret") String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_box", new ParamsOfNaclBox(decrypted, nonce, theirPublic, secretKey), ResultOfNaclBox.class);
    }

    public static ResultOfNaclBoxOpen naclBoxOpen(EverSdkContext ctx, String encrypted, String nonce, String theirPublic, @JsonProperty(value="secret") String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_box_open", new ParamsOfNaclBoxOpen(encrypted, nonce, theirPublic, secretKey), ResultOfNaclBoxOpen.class);
    }

    public static ResultOfNaclBox naclSecretBox(EverSdkContext ctx, String decrypted, String nonce, String key) throws EverSdkException {
        return ctx.call("crypto.nacl_secret_box", new ParamsOfNaclSecretBox(decrypted, nonce, key), ResultOfNaclBox.class);
    }

    public static ResultOfNaclBoxOpen naclSecretBoxOpen(EverSdkContext ctx, String encrypted, String nonce, String key) throws EverSdkException {
        return ctx.call("crypto.nacl_secret_box_open", new ParamsOfNaclSecretBoxOpen(encrypted, nonce, key), ResultOfNaclBoxOpen.class);
    }

    public static ResultOfMnemonicWords mnemonicWords(EverSdkContext ctx, MnemonicDictionary dictionary) throws EverSdkException {
        return ctx.call("crypto.mnemonic_words", new ParamsOfMnemonicWords(dictionary), ResultOfMnemonicWords.class);
    }

    public static ResultOfMnemonicFromRandom mnemonicFromRandom(EverSdkContext ctx, MnemonicDictionary dictionary, Integer wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_from_random", new ParamsOfMnemonicFromRandom(dictionary, wordCount), ResultOfMnemonicFromRandom.class);
    }

    public static ResultOfMnemonicFromEntropy mnemonicFromEntropy(EverSdkContext ctx, String entropy, MnemonicDictionary dictionary, Integer wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_from_entropy", new ParamsOfMnemonicFromEntropy(entropy, dictionary, wordCount), ResultOfMnemonicFromEntropy.class);
    }

    public static ResultOfMnemonicVerify mnemonicVerify(EverSdkContext ctx, String phrase, MnemonicDictionary dictionary, Integer wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_verify", new ParamsOfMnemonicVerify(phrase, dictionary, wordCount), ResultOfMnemonicVerify.class);
    }

    public static KeyPair mnemonicDeriveSignKeys(EverSdkContext ctx, String phrase, String path, MnemonicDictionary dictionary, Integer wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_derive_sign_keys", new ParamsOfMnemonicDeriveSignKeys(phrase, path, dictionary, wordCount), KeyPair.class);
    }

    public static ResultOfHDKeyXPrvFromMnemonic hdkeyXprvFromMnemonic(EverSdkContext ctx, String phrase, MnemonicDictionary dictionary, Integer wordCount) throws EverSdkException {
        return ctx.call("crypto.hdkey_xprv_from_mnemonic", new ParamsOfHDKeyXPrvFromMnemonic(phrase, dictionary, wordCount), ResultOfHDKeyXPrvFromMnemonic.class);
    }

    public static ResultOfHDKeyDeriveFromXPrv hdkeyDeriveFromXprv(EverSdkContext ctx, String xprv, Integer childIndex, Boolean hardened) throws EverSdkException {
        return ctx.call("crypto.hdkey_derive_from_xprv", new ParamsOfHDKeyDeriveFromXPrv(xprv, childIndex, hardened), ResultOfHDKeyDeriveFromXPrv.class);
    }

    public static ResultOfHDKeyDeriveFromXPrvPath hdkeyDeriveFromXprvPath(EverSdkContext ctx, String xprv, String path) throws EverSdkException {
        return ctx.call("crypto.hdkey_derive_from_xprv_path", new ParamsOfHDKeyDeriveFromXPrvPath(xprv, path), ResultOfHDKeyDeriveFromXPrvPath.class);
    }

    public static ResultOfHDKeySecretFromXPrv hdkeySecretFromXprv(EverSdkContext ctx, String xprv) throws EverSdkException {
        return ctx.call("crypto.hdkey_secret_from_xprv", new ParamsOfHDKeySecretFromXPrv(xprv), ResultOfHDKeySecretFromXPrv.class);
    }

    public static ResultOfHDKeyPublicFromXPrv hdkeyPublicFromXprv(EverSdkContext ctx, String xprv) throws EverSdkException {
        return ctx.call("crypto.hdkey_public_from_xprv", new ParamsOfHDKeyPublicFromXPrv(xprv), ResultOfHDKeyPublicFromXPrv.class);
    }

    public static ResultOfChaCha20 chacha20(EverSdkContext ctx, String data, String key, String nonce) throws EverSdkException {
        return ctx.call("crypto.chacha20", new ParamsOfChaCha20(data, key, nonce), ResultOfChaCha20.class);
    }

    public static RegisteredCryptoBox createCryptoBox(EverSdkContext ctx, String secretEncryptionSalt, @JsonProperty(value="secret") CryptoBoxSecret secretKey, AppSigningBox appObject) throws EverSdkException {
        return ctx.callAppObject("crypto.create_crypto_box", new ParamsOfCreateCryptoBox(secretEncryptionSalt, secretKey), appObject, RegisteredCryptoBox.class);
    }

    public static void removeCryptoBox(EverSdkContext ctx, RegisteredCryptoBox params) throws EverSdkException {
        ctx.callVoid("crypto.remove_crypto_box", params);
    }

    public static ResultOfGetCryptoBoxInfo getCryptoBoxInfo(EverSdkContext ctx, RegisteredCryptoBox params) throws EverSdkException {
        return ctx.call("crypto.get_crypto_box_info", params, ResultOfGetCryptoBoxInfo.class);
    }

    public static ResultOfGetCryptoBoxSeedPhrase getCryptoBoxSeedPhrase(EverSdkContext ctx, RegisteredCryptoBox params) throws EverSdkException {
        return ctx.call("crypto.get_crypto_box_seed_phrase", params, ResultOfGetCryptoBoxSeedPhrase.class);
    }

    public static RegisteredSigningBox getSigningBoxFromCryptoBox(EverSdkContext ctx, Integer handle, String hdpath, Integer secretLifetime) throws EverSdkException {
        return ctx.call("crypto.get_signing_box_from_crypto_box", new ParamsOfGetSigningBoxFromCryptoBox(handle, hdpath, secretLifetime), RegisteredSigningBox.class);
    }

    public static RegisteredEncryptionBox getEncryptionBoxFromCryptoBox(EverSdkContext ctx, Integer handle, String hdpath, BoxEncryptionAlgorithm algorithm, Integer secretLifetime) throws EverSdkException {
        return ctx.call("crypto.get_encryption_box_from_crypto_box", new ParamsOfGetEncryptionBoxFromCryptoBox(handle, hdpath, algorithm, secretLifetime), RegisteredEncryptionBox.class);
    }

    public static void clearCryptoBoxSecretCache(EverSdkContext ctx, RegisteredCryptoBox params) throws EverSdkException {
        ctx.callVoid("crypto.clear_crypto_box_secret_cache", params);
    }

    public static RegisteredSigningBox registerSigningBox(EverSdkContext ctx, AppSigningBox appObject) throws EverSdkException {
        return ctx.callAppObject("crypto.register_signing_box", null, appObject, RegisteredSigningBox.class);
    }

    public static RegisteredSigningBox getSigningBox(EverSdkContext ctx, KeyPair params) throws EverSdkException {
        return ctx.call("crypto.get_signing_box", params, RegisteredSigningBox.class);
    }

    public static ResultOfSigningBoxGetPublicKey signingBoxGetPublicKey(EverSdkContext ctx, RegisteredSigningBox params) throws EverSdkException {
        return ctx.call("crypto.signing_box_get_public_key", params, ResultOfSigningBoxGetPublicKey.class);
    }

    public static ResultOfSigningBoxSign signingBoxSign(EverSdkContext ctx, Integer signingBox, String unsigned) throws EverSdkException {
        return ctx.call("crypto.signing_box_sign", new ParamsOfSigningBoxSign(signingBox, unsigned), ResultOfSigningBoxSign.class);
    }

    public static void removeSigningBox(EverSdkContext ctx, RegisteredSigningBox params) throws EverSdkException {
        ctx.callVoid("crypto.remove_signing_box", params);
    }

    public static RegisteredEncryptionBox registerEncryptionBox(EverSdkContext ctx, AppSigningBox appObject) throws EverSdkException {
        return ctx.callAppObject("crypto.register_encryption_box", null, appObject, RegisteredEncryptionBox.class);
    }

    public static void removeEncryptionBox(EverSdkContext ctx, RegisteredEncryptionBox params) throws EverSdkException {
        ctx.callVoid("crypto.remove_encryption_box", params);
    }

    public static ResultOfEncryptionBoxGetInfo encryptionBoxGetInfo(EverSdkContext ctx, Integer encryptionBox) throws EverSdkException {
        return ctx.call("crypto.encryption_box_get_info", new ParamsOfEncryptionBoxGetInfo(encryptionBox), ResultOfEncryptionBoxGetInfo.class);
    }

    public static ResultOfEncryptionBoxEncrypt encryptionBoxEncrypt(EverSdkContext ctx, Integer encryptionBox, String data) throws EverSdkException {
        return ctx.call("crypto.encryption_box_encrypt", new ParamsOfEncryptionBoxEncrypt(encryptionBox, data), ResultOfEncryptionBoxEncrypt.class);
    }

    public static ResultOfEncryptionBoxDecrypt encryptionBoxDecrypt(EverSdkContext ctx, Integer encryptionBox, String data) throws EverSdkException {
        return ctx.call("crypto.encryption_box_decrypt", new ParamsOfEncryptionBoxDecrypt(encryptionBox, data), ResultOfEncryptionBoxDecrypt.class);
    }

    public static RegisteredEncryptionBox createEncryptionBox(EverSdkContext ctx, EncryptionAlgorithm algorithm) throws EverSdkException {
        return ctx.call("crypto.create_encryption_box", new ParamsOfCreateEncryptionBox(algorithm), RegisteredEncryptionBox.class);
    }

    public record ParamsOfFactorize(String composite) {
    }

    public record ResultOfFactorize(String[] factors) {
    }

    public record ParamsOfModularPower(String base, String exponent, String modulus) {
    }

    public record ResultOfModularPower(String modularPower) {
    }

    public record ParamsOfTonCrc16(String data) {
    }

    public record ResultOfTonCrc16(Integer crc) {
    }

    public record ParamsOfGenerateRandomBytes(Integer length) {
    }

    public record ResultOfGenerateRandomBytes(String bytes) {
    }

    public record ParamsOfConvertPublicKeyToTonSafeFormat(String publicKey) {
    }

    public record ResultOfConvertPublicKeyToTonSafeFormat(String tonPublicKey) {
    }

    public record KeyPair(@JsonProperty(value="public") String publicKey, @JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfSign(String unsigned, KeyPair keys) {
    }

    public record ResultOfSign(String signed, String signature) {
    }

    public record ParamsOfVerifySignature(String signed, @JsonProperty(value="public") String publicKey) {
    }

    public record ResultOfVerifySignature(String unsigned) {
    }

    public record ParamsOfHash(String data) {
    }

    public record ResultOfHash(String hash) {
    }

    public record ParamsOfScrypt(String password, String salt, Integer logN, Integer r, Integer p, Integer dkLen) {
    }

    public record ResultOfScrypt(String key) {
    }

    public record ParamsOfNaclSignKeyPairFromSecret(@JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfNaclSign(String unsigned, @JsonProperty(value="secret") String secretKey) {
    }

    public record ResultOfNaclSign(String signed) {
    }

    public record ParamsOfNaclSignOpen(String signed, @JsonProperty(value="public") String publicKey) {
    }

    public record ResultOfNaclSignOpen(String unsigned) {
    }

    public record ResultOfNaclSignDetached(String signature) {
    }

    public record ParamsOfNaclSignDetachedVerify(String unsigned, String signature, @JsonProperty(value="public") String publicKey) {
    }

    public record ResultOfNaclSignDetachedVerify(Boolean succeeded) {
    }

    public record ParamsOfNaclBoxKeyPairFromSecret(@JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfNaclBox(String decrypted, String nonce, String theirPublic, @JsonProperty(value="secret") String secretKey) {
    }

    public record ResultOfNaclBox(String encrypted) {
    }

    public record ParamsOfNaclBoxOpen(String encrypted, String nonce, String theirPublic, @JsonProperty(value="secret") String secretKey) {
    }

    public record ResultOfNaclBoxOpen(String decrypted) {
    }

    public record ParamsOfNaclSecretBox(String decrypted, String nonce, String key) {
    }

    public record ParamsOfNaclSecretBoxOpen(String encrypted, String nonce, String key) {
    }

    public record ParamsOfMnemonicWords(MnemonicDictionary dictionary) {
    }

    public static enum MnemonicDictionary {
        Ton(0),
        English(1),
        ChineseSimplified(2),
        ChineseTraditional(3),
        French(4),
        Italian(5),
        Japanese(6),
        Korean(7),
        Spanish(8);

        private final Integer value;

        private MnemonicDictionary(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record ResultOfMnemonicWords(String words) {
    }

    public record ParamsOfMnemonicFromRandom(MnemonicDictionary dictionary, Integer wordCount) {
    }

    public record ResultOfMnemonicFromRandom(String phrase) {
    }

    public record ParamsOfMnemonicFromEntropy(String entropy, MnemonicDictionary dictionary, Integer wordCount) {
    }

    public record ResultOfMnemonicFromEntropy(String phrase) {
    }

    public record ParamsOfMnemonicVerify(String phrase, MnemonicDictionary dictionary, Integer wordCount) {
    }

    public record ResultOfMnemonicVerify(Boolean valid) {
    }

    public record ParamsOfMnemonicDeriveSignKeys(String phrase, String path, MnemonicDictionary dictionary, Integer wordCount) {
    }

    public record ParamsOfHDKeyXPrvFromMnemonic(String phrase, MnemonicDictionary dictionary, Integer wordCount) {
    }

    public record ResultOfHDKeyXPrvFromMnemonic(String xprv) {
    }

    public record ParamsOfHDKeyDeriveFromXPrv(String xprv, Integer childIndex, Boolean hardened) {
    }

    public record ResultOfHDKeyDeriveFromXPrv(String xprv) {
    }

    public record ParamsOfHDKeyDeriveFromXPrvPath(String xprv, String path) {
    }

    public record ResultOfHDKeyDeriveFromXPrvPath(String xprv) {
    }

    public record ParamsOfHDKeySecretFromXPrv(String xprv) {
    }

    public record ResultOfHDKeySecretFromXPrv(@JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfHDKeyPublicFromXPrv(String xprv) {
    }

    public record ResultOfHDKeyPublicFromXPrv(@JsonProperty(value="public") String publicKey) {
    }

    public record ParamsOfChaCha20(String data, String key, String nonce) {
    }

    public record ResultOfChaCha20(String data) {
    }

    public record ParamsOfCreateCryptoBox(String secretEncryptionSalt, @JsonProperty(value="secret") CryptoBoxSecret secretKey) {
    }

    public static sealed interface CryptoBoxSecret {

        public record EncryptedSecret(String encryptedSecret) implements CryptoBoxSecret
        {
            @JsonProperty(value="type")
            public String type() {
                return "EncryptedSecret";
            }
        }

        public record PredefinedSeedPhrase(String phrase, MnemonicDictionary dictionary, Integer wordcount) implements CryptoBoxSecret
        {
            @JsonProperty(value="type")
            public String type() {
                return "PredefinedSeedPhrase";
            }
        }

        public record RandomSeedPhrase(MnemonicDictionary dictionary, Integer wordcount) implements CryptoBoxSecret
        {
            @JsonProperty(value="type")
            public String type() {
                return "RandomSeedPhrase";
            }
        }
    }

    public record RegisteredCryptoBox(Integer handle) {
    }

    public record ResultOfGetCryptoBoxInfo(String encryptedSecret) {
    }

    public record ResultOfGetCryptoBoxSeedPhrase(String phrase, MnemonicDictionary dictionary, Integer wordcount) {
    }

    public record ParamsOfGetSigningBoxFromCryptoBox(Integer handle, String hdpath, Integer secretLifetime) {
    }

    public record RegisteredSigningBox(Integer handle) {
    }

    public record ParamsOfGetEncryptionBoxFromCryptoBox(Integer handle, String hdpath, BoxEncryptionAlgorithm algorithm, Integer secretLifetime) {
    }

    public static sealed interface BoxEncryptionAlgorithm {

        public record NaclSecretBox(NaclSecretBoxParamsCB value) implements BoxEncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "NaclSecretBox";
            }
        }

        public record NaclBox(NaclBoxParamsCB value) implements BoxEncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "NaclBox";
            }
        }

        public record ChaCha20(ChaCha20ParamsCB value) implements BoxEncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "ChaCha20";
            }
        }
    }

    public record RegisteredEncryptionBox(Integer handle) {
    }

    public record ResultOfSigningBoxGetPublicKey(String pubkey) {
    }

    public record ParamsOfSigningBoxSign(Integer signingBox, String unsigned) {
    }

    public record ResultOfSigningBoxSign(String signature) {
    }

    public record ParamsOfEncryptionBoxGetInfo(Integer encryptionBox) {
    }

    public record ResultOfEncryptionBoxGetInfo(EncryptionBoxInfo info) {
    }

    public record ParamsOfEncryptionBoxEncrypt(Integer encryptionBox, String data) {
    }

    public record ResultOfEncryptionBoxEncrypt(String data) {
    }

    public record ParamsOfEncryptionBoxDecrypt(Integer encryptionBox, String data) {
    }

    public record ResultOfEncryptionBoxDecrypt(String data) {
    }

    public record ParamsOfCreateEncryptionBox(EncryptionAlgorithm algorithm) {
    }

    public static sealed interface EncryptionAlgorithm {

        public record NaclSecretBox(NaclSecretBoxParamsEB value) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "NaclSecretBox";
            }
        }

        public record NaclBox(NaclBoxParamsEB value) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "NaclBox";
            }
        }

        public record ChaCha20(ChaCha20ParamsEB value) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "ChaCha20";
            }
        }

        public record AES(AesParamsEB value) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return "AES";
            }
        }
    }

    public record NaclSecretBoxParamsEB(String key, String nonce) {
    }

    public static sealed interface ParamsOfAppPasswordProvider {

        public record GetPassword(String encryptionPublicKey) implements ParamsOfAppPasswordProvider
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetPassword";
            }
        }
    }

    public record AesInfo(CipherMode mode, String iv) {
    }

    public record NaclSecretBoxParamsCB(String nonce) {
    }

    public static sealed interface ResultOfAppPasswordProvider {

        public record GetPassword(String encryptedPassword, String appEncryptionPubkey) implements ResultOfAppPasswordProvider
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetPassword";
            }
        }
    }

    public static sealed interface ResultOfAppSigningBox {

        public record Sign(String signature) implements ResultOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "Sign";
            }
        }

        public record GetPublicKey(String publicKey) implements ResultOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetPublicKey";
            }
        }
    }

    public static sealed interface ParamsOfAppEncryptionBox {

        public record Decrypt(String data) implements ParamsOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "Decrypt";
            }
        }

        public record Encrypt(String data) implements ParamsOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "Encrypt";
            }
        }

        public record GetInfo() implements ParamsOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetInfo";
            }
        }
    }

    public record EncryptionBoxInfo(String hdpath, String algorithm, Map<String, Object> options, @JsonProperty(value="public") Map<String, Object> publicKey) {
    }

    public record NaclBoxParamsCB(String theirPublic, String nonce) {
    }

    public record AesParamsEB(CipherMode mode, String key, String iv) {
    }

    public static sealed interface ResultOfAppEncryptionBox {

        public record Decrypt(String data) implements ResultOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "Decrypt";
            }
        }

        public record Encrypt(String data) implements ResultOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "Encrypt";
            }
        }

        public record GetInfo(EncryptionBoxInfo info) implements ResultOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetInfo";
            }
        }
    }

    public record ChaCha20ParamsCB(String nonce) {
    }

    public static enum CryptoErrorCode {
        InvalidPublicKey(100),
        InvalidSecretKey(101),
        InvalidKey(102),
        InvalidFactorizeChallenge(106),
        InvalidBigInt(107),
        ScryptFailed(108),
        InvalidKeySize(109),
        NaclSecretBoxFailed(110),
        NaclBoxFailed(111),
        NaclSignFailed(112),
        Bip39InvalidEntropy(113),
        Bip39InvalidPhrase(114),
        Bip32InvalidKey(115),
        Bip32InvalidDerivePath(116),
        Bip39InvalidDictionary(117),
        Bip39InvalidWordCount(118),
        MnemonicGenerationFailed(119),
        MnemonicFromEntropyFailed(120),
        SigningBoxNotRegistered(121),
        InvalidSignature(122),
        EncryptionBoxNotRegistered(123),
        InvalidIvSize(124),
        UnsupportedCipherMode(125),
        CannotCreateCipher(126),
        EncryptDataError(127),
        DecryptDataError(128),
        IvRequired(129),
        CryptoBoxNotRegistered(130),
        InvalidCryptoBoxType(131),
        CryptoBoxSecretSerializationError(132),
        CryptoBoxSecretDeserializationError(133),
        InvalidNonceSize(134);

        private final Integer value;

        private CryptoErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public static enum CipherMode {
        CBC,
        CFB,
        CTR,
        ECB,
        OFB;

    }

    public record ChaCha20ParamsEB(String key, String nonce) {
    }

    public static sealed interface ParamsOfAppSigningBox {

        public record Sign(String unsigned) implements ParamsOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "Sign";
            }
        }

        public record GetPublicKey() implements ParamsOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetPublicKey";
            }
        }
    }

    public record NaclBoxParamsEB(String theirPublic, @JsonProperty(value="secret") String secretKey, String nonce) {
    }
}

