/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SegmentScope;
import java.lang.foreign.ValueLayout;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import tech.deplant.java4ever.binding.ffi.SdkResponseHandler;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;
import tech.deplant.java4ever.binding.ffi.tc_string_data_t;
import tech.deplant.java4ever.binding.ffi.ton_client;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public class SdkBridge {
    public static String tcCreateContext(LibraryLoader loader, String configJson) {
        loader.load();
        return SdkBridge.toString(ton_client.tc_read_string(SegmentAllocator.nativeAllocator((SegmentScope)SegmentScope.auto()), ton_client.tc_create_context(SdkBridge.ofString(configJson))));
    }

    public static SdkResponseHandler tcRequest(int contextId, int requestId, String functionName, String params) {
        SdkResponseHandler response = new SdkResponseHandler();
        ton_client.tc_request(contextId, SdkBridge.ofString(functionName), SdkBridge.ofString(params), requestId, tc_response_handler_t.allocate(response, Arena.openShared().scope()));
        return response;
    }

    public static MemorySegment ofString(String text) {
        MemorySegment stringData = tc_string_data_t.allocate(SegmentAllocator.nativeAllocator((SegmentScope)SegmentScope.auto()));
        MemorySegment nativeString = SdkBridge.fromJavaString(SegmentAllocator.nativeAllocator((SegmentScope)SegmentScope.auto()), text, StandardCharsets.UTF_8);
        tc_string_data_t.content$set(stringData, 0L, nativeString);
        tc_string_data_t.len$set(stringData, 0L, (int)nativeString.byteSize() - 1);
        return stringData;
    }

    public static String toString(MemorySegment seg) {
        return SdkBridge.toJavaString(seg);
    }

    private static String toJavaString(MemorySegment segment, int len) {
        byte[] bytes = new byte[len];
        MemorySegment.copy(segment, ValueLayout.JAVA_BYTE, 0L, bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static String toJavaString(MemorySegment seg) {
        if (tc_string_data_t.len$get(seg) > 0) {
            MemorySegment addressSegment = tc_string_data_t.content$get(seg);
            byte[] str = MemorySegment.ofAddress((long)addressSegment.address(), (long)tc_string_data_t.len$get(seg), (SegmentScope)SegmentScope.auto()).toArray(ValueLayout.JAVA_BYTE);
            return new String(str, StandardCharsets.UTF_8);
        }
        return "";
    }

    private static int strLength(MemorySegment seg) {
        return tc_string_data_t.len$get(seg);
    }

    private static MemorySegment fromJavaString(SegmentAllocator allocator, String s, Charset charset) {
        if (StandardCharsets.UTF_8 == charset) {
            return allocator.allocateUtf8String(s);
        }
        return allocator.allocateArray(ValueLayout.JAVA_BYTE, (s + "\u0000").getBytes(charset));
    }
}

