/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.util.wallet;

import com.google.common.io.BaseEncoding;
import io.provenance.scope.encryption.ecies.ECUtils;
import io.provenance.scope.encryption.model.DirectKeyRef;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.classification.asset.util.enums.ProvenanceNetworkType;
import tech.figure.classification.asset.util.extensions.ByteArrayExtensionsKt;
import tech.figure.classification.asset.util.objects.ACMetadataKeyUtil;
import tech.figure.classification.asset.util.wallet.AccountSigner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0006\u0010#\u001a\u00020$J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Ltech/figure/classification/asset/util/wallet/ProvenanceAccountDetail;", "", "bech32Address", "", "publicKey", "Ljava/security/PublicKey;", "privateKey", "Ljava/security/PrivateKey;", "encodedPublicKey", "encodedPrivateKey", "keyRef", "Lio/provenance/scope/encryption/model/KeyRef;", "(Ljava/lang/String;Ljava/security/PublicKey;Ljava/security/PrivateKey;Ljava/lang/String;Ljava/lang/String;Lio/provenance/scope/encryption/model/KeyRef;)V", "getBech32Address", "()Ljava/lang/String;", "getEncodedPrivateKey", "getEncodedPublicKey", "getKeyRef", "()Lio/provenance/scope/encryption/model/KeyRef;", "getPrivateKey", "()Ljava/security/PrivateKey;", "getPublicKey", "()Ljava/security/PublicKey;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toAccountSigner", "Ltech/figure/classification/asset/util/wallet/AccountSigner;", "toString", "Companion", "util"})
public final class ProvenanceAccountDetail {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bech32Address;
    @NotNull
    private final PublicKey publicKey;
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final String encodedPublicKey;
    @NotNull
    private final String encodedPrivateKey;
    @NotNull
    private final KeyRef keyRef;

    public ProvenanceAccountDetail(@NotNull String bech32Address, @NotNull PublicKey publicKey, @NotNull PrivateKey privateKey, @NotNull String encodedPublicKey, @NotNull String encodedPrivateKey, @NotNull KeyRef keyRef) {
        Intrinsics.checkNotNullParameter((Object)bech32Address, (String)"bech32Address");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)encodedPublicKey, (String)"encodedPublicKey");
        Intrinsics.checkNotNullParameter((Object)encodedPrivateKey, (String)"encodedPrivateKey");
        Intrinsics.checkNotNullParameter((Object)keyRef, (String)"keyRef");
        this.bech32Address = bech32Address;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.encodedPublicKey = encodedPublicKey;
        this.encodedPrivateKey = encodedPrivateKey;
        this.keyRef = keyRef;
    }

    @NotNull
    public final String getBech32Address() {
        return this.bech32Address;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final String getEncodedPublicKey() {
        return this.encodedPublicKey;
    }

    @NotNull
    public final String getEncodedPrivateKey() {
        return this.encodedPrivateKey;
    }

    @NotNull
    public final KeyRef getKeyRef() {
        return this.keyRef;
    }

    @NotNull
    public final AccountSigner toAccountSigner() {
        return AccountSigner.Companion.fromAccountDetail(this);
    }

    @NotNull
    public final String component1() {
        return this.bech32Address;
    }

    @NotNull
    public final PublicKey component2() {
        return this.publicKey;
    }

    @NotNull
    public final PrivateKey component3() {
        return this.privateKey;
    }

    @NotNull
    public final String component4() {
        return this.encodedPublicKey;
    }

    @NotNull
    public final String component5() {
        return this.encodedPrivateKey;
    }

    @NotNull
    public final KeyRef component6() {
        return this.keyRef;
    }

    @NotNull
    public final ProvenanceAccountDetail copy(@NotNull String bech32Address, @NotNull PublicKey publicKey, @NotNull PrivateKey privateKey, @NotNull String encodedPublicKey, @NotNull String encodedPrivateKey, @NotNull KeyRef keyRef) {
        Intrinsics.checkNotNullParameter((Object)bech32Address, (String)"bech32Address");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)encodedPublicKey, (String)"encodedPublicKey");
        Intrinsics.checkNotNullParameter((Object)encodedPrivateKey, (String)"encodedPrivateKey");
        Intrinsics.checkNotNullParameter((Object)keyRef, (String)"keyRef");
        return new ProvenanceAccountDetail(bech32Address, publicKey, privateKey, encodedPublicKey, encodedPrivateKey, keyRef);
    }

    public static /* synthetic */ ProvenanceAccountDetail copy$default(ProvenanceAccountDetail provenanceAccountDetail, String string, PublicKey publicKey, PrivateKey privateKey, String string2, String string3, KeyRef keyRef, int n, Object object) {
        if ((n & 1) != 0) {
            string = provenanceAccountDetail.bech32Address;
        }
        if ((n & 2) != 0) {
            publicKey = provenanceAccountDetail.publicKey;
        }
        if ((n & 4) != 0) {
            privateKey = provenanceAccountDetail.privateKey;
        }
        if ((n & 8) != 0) {
            string2 = provenanceAccountDetail.encodedPublicKey;
        }
        if ((n & 0x10) != 0) {
            string3 = provenanceAccountDetail.encodedPrivateKey;
        }
        if ((n & 0x20) != 0) {
            keyRef = provenanceAccountDetail.keyRef;
        }
        return provenanceAccountDetail.copy(string, publicKey, privateKey, string2, string3, keyRef);
    }

    @NotNull
    public String toString() {
        return "ProvenanceAccountDetail(bech32Address=" + this.bech32Address + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", encodedPublicKey=" + this.encodedPublicKey + ", encodedPrivateKey=" + this.encodedPrivateKey + ", keyRef=" + this.keyRef + ")";
    }

    public int hashCode() {
        int result = this.bech32Address.hashCode();
        result = result * 31 + this.publicKey.hashCode();
        result = result * 31 + this.privateKey.hashCode();
        result = result * 31 + this.encodedPublicKey.hashCode();
        result = result * 31 + this.encodedPrivateKey.hashCode();
        result = result * 31 + this.keyRef.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProvenanceAccountDetail)) {
            return false;
        }
        ProvenanceAccountDetail provenanceAccountDetail = (ProvenanceAccountDetail)other;
        if (!Intrinsics.areEqual((Object)this.bech32Address, (Object)provenanceAccountDetail.bech32Address)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.publicKey, (Object)provenanceAccountDetail.publicKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.privateKey, (Object)provenanceAccountDetail.privateKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.encodedPublicKey, (Object)provenanceAccountDetail.encodedPublicKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.encodedPrivateKey, (Object)provenanceAccountDetail.encodedPrivateKey)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyRef, (Object)provenanceAccountDetail.keyRef);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Ltech/figure/classification/asset/util/wallet/ProvenanceAccountDetail$Companion;", "", "()V", "fromBase64PrivateKey", "Ltech/figure/classification/asset/util/wallet/ProvenanceAccountDetail;", "privateKeyEncoded", "", "mainNet", "", "fromJavaPrivateKey", "privateKey", "Ljava/security/PrivateKey;", "fromMnemonic", "mnemonic", "networkType", "Ltech/figure/classification/asset/util/enums/ProvenanceNetworkType;", "passphrase", "util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProvenanceAccountDetail fromJavaPrivateKey(@NotNull PrivateKey privateKey, boolean mainNet, @Nullable String privateKeyEncoded) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            KeyPair keyPair = KeyExtensionsKt.toKeyPair((PrivateKey)privateKey);
            boolean bl = false;
            PublicKey publicKey = keyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.public");
            String string = KeyExtensionsKt.getAddress((PublicKey)publicKey, (boolean)mainNet);
            PublicKey publicKey2 = keyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"keyPair.public");
            PrivateKey privateKey2 = keyPair.getPrivate();
            Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"keyPair.private");
            PublicKey publicKey3 = keyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey3, (String)"keyPair.public");
            String string2 = ByteArrayExtensionsKt.base64EncodeStringAc(ECUtils.INSTANCE.convertPublicKeyToBytes(publicKey3));
            String string3 = privateKeyEncoded;
            if (string3 == null) {
                string3 = ACMetadataKeyUtil.INSTANCE.getBase64EncodedPrivateKey(privateKey);
            }
            return new ProvenanceAccountDetail(string, publicKey2, privateKey2, string2, string3, (KeyRef)new DirectKeyRef(keyPair));
        }

        public static /* synthetic */ ProvenanceAccountDetail fromJavaPrivateKey$default(Companion companion, PrivateKey privateKey, boolean bl, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = null;
            }
            return companion.fromJavaPrivateKey(privateKey, bl, string);
        }

        @NotNull
        public final ProvenanceAccountDetail fromBase64PrivateKey(@NotNull String privateKeyEncoded, boolean mainNet) {
            Intrinsics.checkNotNullParameter((Object)privateKeyEncoded, (String)"privateKeyEncoded");
            byte[] byArray = BaseEncoding.base64().decode((CharSequence)privateKeyEncoded);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"base64().decode(privateKeyEncoded)");
            return this.fromJavaPrivateKey(ECUtils.convertBytesToPrivateKey$default((ECUtils)ECUtils.INSTANCE, (byte[])byArray, null, (int)2, null), mainNet, privateKeyEncoded);
        }

        @NotNull
        public final ProvenanceAccountDetail fromMnemonic(@NotNull String mnemonic, @NotNull ProvenanceNetworkType networkType, @NotNull String passphrase) {
            Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
            Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            return this.fromBase64PrivateKey(ACMetadataKeyUtil.INSTANCE.getBase64EncodedPrivateKey(mnemonic, networkType, passphrase), networkType.isMainNet());
        }

        public static /* synthetic */ ProvenanceAccountDetail fromMnemonic$default(Companion companion, String string, ProvenanceNetworkType provenanceNetworkType, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            return companion.fromMnemonic(string, provenanceNetworkType, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

