/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.classification.asset.util.wallet;

import com.google.protobuf.ByteString;
import cosmos.crypto.secp256k1.Keys;
import io.provenance.client.grpc.Signer;
import io.provenance.hdwallet.ec.ECKeyPair;
import io.provenance.hdwallet.ec.extensions.JavaKeysKt;
import io.provenance.hdwallet.signer.BCECSigner;
import io.provenance.hdwallet.signer.BTCSignature;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.util.ExtensionsKt;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.figure.classification.asset.util.enums.ProvenanceNetworkType;
import tech.figure.classification.asset.util.wallet.ProvenanceAccountDetail;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ltech/figure/classification/asset/util/wallet/AccountSigner;", "Lio/provenance/client/grpc/Signer;", "address", "", "publicKey", "Lio/provenance/hdwallet/ec/PublicKey;", "privateKey", "Lio/provenance/hdwallet/ec/PrivateKey;", "(Ljava/lang/String;Lio/provenance/hdwallet/ec/PublicKey;Lio/provenance/hdwallet/ec/PrivateKey;)V", "pubKey", "Lcosmos/crypto/secp256k1/Keys$PubKey;", "sign", "", "data", "Companion", "util"})
public final class AccountSigner
implements Signer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String address;
    @NotNull
    private final io.provenance.hdwallet.ec.PublicKey publicKey;
    @NotNull
    private final io.provenance.hdwallet.ec.PrivateKey privateKey;

    public AccountSigner(@NotNull String address, @NotNull io.provenance.hdwallet.ec.PublicKey publicKey, @NotNull io.provenance.hdwallet.ec.PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.address = address;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @NotNull
    public String address() {
        return this.address;
    }

    @NotNull
    public Keys.PubKey pubKey() {
        Keys.PubKey pubKey = Keys.PubKey.newBuilder().setKey(ByteString.copyFrom((byte[])this.publicKey.compressed())).build();
        Intrinsics.checkNotNullExpressionValue((Object)pubKey, (String)"newBuilder().setKey(Byte\u2026ey.compressed())).build()");
        return pubKey;
    }

    @NotNull
    public byte[] sign(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BTCSignature.toByteArray-impl((byte[])new BCECSigner().sign(this.privateKey, ExtensionsKt.sha256((byte[])data)).encodeAsBTC-nYhD9t8());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Ltech/figure/classification/asset/util/wallet/AccountSigner$Companion;", "", "()V", "fromAccountDetail", "Ltech/figure/classification/asset/util/wallet/AccountSigner;", "accountDetail", "Ltech/figure/classification/asset/util/wallet/ProvenanceAccountDetail;", "fromECPrivateKey", "privateKey", "Lio/provenance/hdwallet/ec/PrivateKey;", "mainNet", "", "fromJavaPrivateKey", "Ljava/security/PrivateKey;", "fromMnemonic", "mnemonic", "", "networkType", "Ltech/figure/classification/asset/util/enums/ProvenanceNetworkType;", "util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AccountSigner fromAccountDetail(@NotNull ProvenanceAccountDetail accountDetail) {
            Intrinsics.checkNotNullParameter((Object)accountDetail, (String)"accountDetail");
            ECKeyPair keyPair = JavaKeysKt.toECPrivateKey((PrivateKey)accountDetail.getPrivateKey()).toECKeyPair();
            boolean bl = false;
            return new AccountSigner(accountDetail.getBech32Address(), keyPair.getPublicKey(), keyPair.getPrivateKey());
        }

        @NotNull
        public final AccountSigner fromJavaPrivateKey(@NotNull PrivateKey privateKey, boolean mainNet) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return this.fromECPrivateKey(JavaKeysKt.toECPrivateKey((PrivateKey)privateKey), mainNet);
        }

        @NotNull
        public final AccountSigner fromECPrivateKey(@NotNull io.provenance.hdwallet.ec.PrivateKey privateKey, boolean mainNet) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            KeyPair keyPair = KeyExtensionsKt.toKeyPair((PrivateKey)JavaKeysKt.toJavaECPrivateKey((io.provenance.hdwallet.ec.PrivateKey)privateKey));
            boolean bl = false;
            PublicKey publicKey = keyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.public");
            return new AccountSigner(KeyExtensionsKt.getAddress((PublicKey)publicKey, (boolean)mainNet), privateKey.toPublicKey(), privateKey);
        }

        @NotNull
        public final AccountSigner fromMnemonic(@NotNull String mnemonic, @NotNull ProvenanceNetworkType networkType) {
            Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
            Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
            return this.fromAccountDetail(ProvenanceAccountDetail.Companion.fromMnemonic$default(ProvenanceAccountDetail.Companion, mnemonic, networkType, null, 4, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

