/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.eventstream.stream.models;

import com.google.common.io.BaseEncoding;
import cosmos.base.v1beta1.CoinOuterClass;
import cosmos.tx.v1beta1.TxOuterClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.eventstream.stream.models.Block;
import tech.figure.eventstream.stream.models.BlockData;
import tech.figure.eventstream.stream.models.BlockEvent;
import tech.figure.eventstream.stream.models.BlockHeader;
import tech.figure.eventstream.stream.models.BlockResponse;
import tech.figure.eventstream.stream.models.BlockResultsResponse;
import tech.figure.eventstream.stream.models.BlockResultsResponseResult;
import tech.figure.eventstream.stream.models.BlockResultsResponseResultEvents;
import tech.figure.eventstream.stream.models.BlockResultsResponseResultTxsResults;
import tech.figure.eventstream.stream.models.Event;
import tech.figure.eventstream.stream.models.InnerCoin;
import tech.figure.eventstream.stream.models.TxData;
import tech.figure.eventstream.stream.models.TxError;
import tech.figure.eventstream.stream.models.TxEvent;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0010\u001a\u0018\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0013*\u00020\u0014\u001a0\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u001c\u0010\u001d\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u001e\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100 *\b\u0012\u0004\u0012\u00020\u00140\u0004\u001a\n\u0010!\u001a\u00020\u0010*\u00020\u0001\u001a\n\u0010\"\u001a\u00020\u001c*\u00020#\u001a:\u0010$\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010%\u001a\u0004\u0018\u00010\u0010\u001a\u0014\u0010&\u001a\u0004\u0018\u00010'*\u00020\n2\u0006\u0010(\u001a\u00020)\u001a0\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u00010'0+\u001a;\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004*\u00020-2\u0006\u0010.\u001a\u00020\b2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b((\u0012\u0004\u0012\u00020'0+\u001a0\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u00010'0+\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010'*\u0002012\u0006\u0010(\u001a\u00020)\u001a\u0010\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004*\u00020\n\u00a8\u00063"}, d2={"sha256", "", "input", "blockEvents", "", "Ltech/figure/eventstream/stream/models/BlockEvent;", "Ltech/figure/eventstream/stream/models/BlockResultsResponseResult;", "blockDateTime", "Ljava/time/OffsetDateTime;", "dateTime", "Ltech/figure/eventstream/stream/models/Block;", "Ltech/figure/eventstream/stream/models/BlockHeader;", "hasAttribute", "", "Ltech/figure/eventstream/stream/models/TxEvent;", "key", "", "hash", "toAttribute", "Lkotlin/Pair;", "Ltech/figure/eventstream/stream/models/Event;", "toBlockError", "Ltech/figure/eventstream/stream/models/TxError;", "Ltech/figure/eventstream/stream/models/BlockResultsResponseResultTxsResults;", "blockHeight", "", "txHash", "fee", "Ltech/figure/eventstream/stream/models/InnerCoin;", "toBlockEvent", "Ltech/figure/eventstream/stream/models/BlockResultsResponseResultEvents;", "toDecodedMap", "", "toHexString", "toInnerCoin", "Lcosmos/base/v1beta1/CoinOuterClass$Coin;", "toTxEvent", "note", "txData", "Ltech/figure/eventstream/stream/models/TxData;", "index", "", "txErroredEvents", "Lkotlin/Function1;", "txEvents", "Ltech/figure/eventstream/stream/models/BlockResultsResponse;", "blockDate", "Lkotlin/ParameterName;", "name", "Ltech/figure/eventstream/stream/models/BlockResponse;", "txHashes", "es-api-model"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ntech/figure/eventstream/stream/models/ExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1549#2:192\n1620#2,3:193\n1549#2:197\n1620#2,3:198\n1549#2:201\n1620#2,3:202\n1559#2:205\n1590#2,4:206\n1747#2,3:210\n1179#2,2:213\n1253#2,4:215\n1#3:196\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ntech/figure/eventstream/stream/models/ExtensionsKt\n*L\n57#1:192\n57#1:193,3\n83#1:197\n83#1:198,3\n98#1:201\n98#1:202,3\n110#1:205\n110#1:206,4\n171#1:210,3\n188#1:213,2\n188#1:215,4\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        String string = BaseEncoding.base16().encode($this$toHexString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    @NotNull
    public static final byte[] sha256(@Nullable byte[] input) {
        byte[] byArray;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byArray = digest.digest(input);
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Couldn't find a SHA-256 provider", e);
        }
        return byArray;
    }

    @NotNull
    public static final String hash(@NotNull String $this$hash) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        return ExtensionsKt.toHexString(ExtensionsKt.sha256(BaseEncoding.base64().decode((CharSequence)$this$hash)));
    }

    @Nullable
    public static final TxData txData(@NotNull Block $this$txData, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$txData, (String)"<this>");
        Object object = $this$txData.getData();
        if (object == null || (object = ((BlockData)object).getTxs()) == null || (object = (String)object.get(index)) == null) {
            return null;
        }
        Object tx2 = object;
        TxOuterClass.Tx decodedTxData = TxOuterClass.Tx.parseFrom((byte[])BaseEncoding.base64().decode((CharSequence)tx2));
        TxOuterClass.Fee feeData = decodedTxData.getAuthInfo().getFee();
        String string = decodedTxData.getBody().getMemo();
        if (string == null) {
            string = "";
        }
        String note = string;
        Object object2 = $this$txData.getData();
        String string2 = object2 != null && (object2 = ((BlockData)object2).getTxs()) != null && (object2 = (String)object2.get(index)) != null ? ExtensionsKt.hash((String)object2) : null;
        List list = feeData.getAmountList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAmountList(...)");
        CoinOuterClass.Coin coin = (CoinOuterClass.Coin)CollectionsKt.firstOrNull((List)list);
        return new TxData(string2, coin != null ? ExtensionsKt.toInnerCoin(coin) : null, note);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> txHashes(@NotNull Block $this$txHashes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$txHashes, (String)"<this>");
        Object object = $this$txHashes.getData();
        if (object != null && (object = ((BlockData)object).getTxs()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ExtensionsKt.hash((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final OffsetDateTime dateTime(@NotNull Block $this$dateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$dateTime, (String)"<this>");
        BlockHeader blockHeader = $this$dateTime.getHeader();
        return blockHeader != null ? ExtensionsKt.dateTime(blockHeader) : null;
    }

    @Nullable
    public static final OffsetDateTime dateTime(@NotNull BlockHeader $this$dateTime) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$dateTime, (String)"<this>");
        Object object2 = $this$dateTime;
        try {
            BlockHeader $this$dateTime_u24lambda_u241 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)OffsetDateTime.parse($this$dateTime_u24lambda_u241.getTime(), DateTimeFormatter.ISO_DATE_TIME));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (OffsetDateTime)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Nullable
    public static final TxData txHash(@NotNull BlockResponse $this$txHash, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$txHash, (String)"<this>");
        Serializable serializable = $this$txHash.getResult();
        return serializable != null && (serializable = serializable.getBlock()) != null ? ExtensionsKt.txData((Block)serializable, index) : null;
    }

    @NotNull
    public static final List<TxEvent> txEvents(@NotNull BlockResultsResponse $this$txEvents, @NotNull OffsetDateTime blockDate, @NotNull Function1<? super Integer, TxData> txHash) {
        Intrinsics.checkNotNullParameter((Object)$this$txEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)blockDate, (String)"blockDate");
        Intrinsics.checkNotNullParameter(txHash, (String)"txHash");
        return ExtensionsKt.txEvents($this$txEvents.getResult(), blockDate, txHash);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TxEvent> txEvents(@NotNull BlockResultsResponseResult $this$txEvents, @Nullable OffsetDateTime blockDateTime, @NotNull Function1<? super Integer, TxData> txHash) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$txEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter(txHash, (String)"txHash");
        BlockResultsResponseResult $this$txEvents_u24lambda_u245 = $this$txEvents;
        boolean bl = false;
        List<BlockResultsResponseResultTxsResults> list2 = $this$txEvents_u24lambda_u245.getTxsResults();
        if (list2 != null) {
            Iterable iterable = list2;
            Collection collection = new ArrayList();
            int n = 0;
            for (Object t : iterable) {
                List list3;
                void tx2;
                int n2;
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BlockResultsResponseResultTxsResults blockResultsResponseResultTxsResults = (BlockResultsResponseResultTxsResults)t;
                int index = n2;
                boolean bl2 = false;
                List<BlockResultsResponseResultEvents> list4 = tx2.getEvents();
                if (list4 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable2 = list4;
                    boolean $i$f$map = false;
                    void var17_17 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void blockResultResponseEvents;
                        BlockResultsResponseResultEvents blockResultsResponseResultEvents = (BlockResultsResponseResultEvents)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl3 = false;
                        TxData txData = (TxData)txHash.invoke((Object)index);
                        boolean bl4 = false;
                        TxData txData2 = txData;
                        TxData txData3 = txData;
                        TxData txData4 = txData;
                        collection2.add(ExtensionsKt.toTxEvent((BlockResultsResponseResultEvents)blockResultResponseEvents, $this$txEvents_u24lambda_u245.getHeight(), blockDateTime, txData2 != null ? txData2.getTxHash() : null, txData3 != null ? txData3.getFee() : null, txData4 != null ? txData4.getNote() : null));
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                CollectionsKt.addAll((Collection)collection, (Iterable)list3);
            }
            list = (List)collection;
        } else {
            list = null;
        }
        List list5 = list;
        if (list == null) {
            list5 = CollectionsKt.emptyList();
        }
        return list5;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BlockEvent> blockEvents(@NotNull BlockResultsResponseResult $this$blockEvents, @Nullable OffsetDateTime blockDateTime) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$blockEvents, (String)"<this>");
        BlockResultsResponseResult $this$blockEvents_u24lambda_u247 = $this$blockEvents;
        boolean bl = false;
        List<BlockResultsResponseResultEvents> list2 = $this$blockEvents_u24lambda_u247.getBeginBlockEvents();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list3;
                void e;
                BlockResultsResponseResultEvents blockResultsResponseResultEvents = (BlockResultsResponseResultEvents)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                long l = $this$blockEvents_u24lambda_u247.getHeight();
                String string = e.getType();
                if (string == null) {
                    string = "";
                }
                if ((list3 = e.getAttributes()) == null) {
                    list3 = CollectionsKt.emptyList();
                }
                collection.add(new BlockEvent(l, blockDateTime, string, list3));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list4 = list;
        if (list == null) {
            list4 = CollectionsKt.emptyList();
        }
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TxError> txErroredEvents(@NotNull BlockResultsResponseResult $this$txErroredEvents, @Nullable OffsetDateTime blockDateTime, @NotNull Function1<? super Integer, TxData> txHash) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$txErroredEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter(txHash, (String)"txHash");
        BlockResultsResponseResult $this$txErroredEvents_u24lambda_u2410 = $this$txErroredEvents;
        boolean bl = false;
        List<BlockResultsResponseResultTxsResults> list2 = $this$txErroredEvents_u24lambda_u2410.getTxsResults();
        if (list2 != null) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = list2;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                TxError txError;
                void tx2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BlockResultsResponseResultTxsResults blockResultsResponseResultTxsResults = (BlockResultsResponseResultTxsResults)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = tx2.getCode();
                if (!(string != null ? Integer.parseInt(string) == 0 : false)) {
                    void index;
                    TxData txData = (TxData)txHash.invoke((Object)((int)index));
                    boolean bl3 = false;
                    TxData txData2 = txData;
                    TxData txData3 = txData;
                    txError = ExtensionsKt.toBlockError((BlockResultsResponseResultTxsResults)tx2, $this$txErroredEvents_u24lambda_u2410.getHeight(), blockDateTime, txData2 != null ? txData2.getTxHash() : null, txData3 != null ? txData3.getFee() : null);
                } else {
                    txError = null;
                }
                collection.add(txError);
            }
            list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        } else {
            list = null;
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    public static final TxError toBlockError(@NotNull BlockResultsResponseResultTxsResults $this$toBlockError, long blockHeight, @Nullable OffsetDateTime blockDateTime, @Nullable String txHash, @Nullable InnerCoin fee) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toBlockError, (String)"<this>");
        String string2 = $this$toBlockError.getCode();
        long l = string2 != null ? Long.parseLong(string2) : 0L;
        String string3 = $this$toBlockError.getLog();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = txHash) == null) {
            string = "";
        }
        if ((object = fee) == null || (object = ((InnerCoin)object).getAmount()) == null) {
            object = BigInteger.ZERO;
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        Object object3 = fee;
        if (object3 == null || (object3 = ((InnerCoin)object3).getDenom()) == null) {
            object3 = "";
        }
        return new TxError(blockHeight, blockDateTime, l, string3, string, (BigInteger)object2, (String)object3);
    }

    @NotNull
    public static final BlockEvent toBlockEvent(@NotNull BlockResultsResponseResultEvents $this$toBlockEvent, long blockHeight, @Nullable OffsetDateTime blockDateTime) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toBlockEvent, (String)"<this>");
        String string = $this$toBlockEvent.getType();
        if (string == null) {
            string = "";
        }
        if ((list = $this$toBlockEvent.getAttributes()) == null) {
            list = CollectionsKt.emptyList();
        }
        return new BlockEvent(blockHeight, blockDateTime, string, list);
    }

    @NotNull
    public static final TxEvent toTxEvent(@NotNull BlockResultsResponseResultEvents $this$toTxEvent, long blockHeight, @Nullable OffsetDateTime blockDateTime, @Nullable String txHash, @Nullable InnerCoin fee, @Nullable String note) {
        List list;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toTxEvent, (String)"<this>");
        String string2 = txHash;
        if (string2 == null) {
            string2 = "";
        }
        if ((string = $this$toTxEvent.getType()) == null) {
            string = "";
        }
        if ((list = $this$toTxEvent.getAttributes()) == null) {
            list = CollectionsKt.emptyList();
        }
        InnerCoin innerCoin = fee;
        InnerCoin innerCoin2 = fee;
        return new TxEvent(blockHeight, blockDateTime, string2, string, list, innerCoin != null ? innerCoin.getAmount() : null, innerCoin2 != null ? innerCoin2.getDenom() : null, note);
    }

    @NotNull
    public static final InnerCoin toInnerCoin(@NotNull CoinOuterClass.Coin $this$toInnerCoin) {
        Intrinsics.checkNotNullParameter((Object)$this$toInnerCoin, (String)"<this>");
        return new InnerCoin($this$toInnerCoin);
    }

    public static final boolean hasAttribute(@NotNull TxEvent $this$hasAttribute, @NotNull String key) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasAttribute, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable $this$any$iv = $this$hasAttribute.getAttributes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Event it = (Event)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, String> toAttribute(@NotNull Event $this$toAttribute) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toAttribute, (String)"<this>");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode($this$toAttribute.getKey());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        String string2 = new String(byArray2, Charsets.UTF_8);
        String string3 = $this$toAttribute.getValue();
        if (string3 != null) {
            void $this$toAttribute_u24lambda_u2412;
            String string4 = string3;
            String string5 = string2;
            boolean bl = false;
            byte[] byArray3 = decoder.decode((String)$this$toAttribute_u24lambda_u2412);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"decode(...)");
            byte[] byArray4 = byArray3;
            string = new String(byArray4, Charsets.UTF_8);
            string2 = string5;
        } else {
            string = null;
        }
        return TuplesKt.to((Object)string2, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> toDecodedMap(@NotNull List<Event> $this$toDecodedMap) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toDecodedMap, (String)"<this>");
        Iterable $this$associate$iv = $this$toDecodedMap;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Event e = (Event)element$iv$iv;
            boolean bl = false;
            byte[] byArray = Base64.getDecoder().decode(e.getKey());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            Pair pair = TuplesKt.to((Object)StringsKt.decodeToString((byte[])byArray), (Object)e.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }
}

