/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common;

import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import tech.generated.common.GeneratedEngine;

public abstract class GeneratedEngineFactory {
    private static final String DEFAULT_ENGINE_NAME = "winter";

    protected abstract GeneratedEngine newEngine(Object ... var1);

    public abstract String getName();

    public static final GeneratedEngine newInstance(String name, Object ... params) {
        GeneratedEngineFactory factory = GeneratedEngineFactory.getInstance(name != null ? name : DEFAULT_ENGINE_NAME);
        GeneratedEngine engine = factory.newEngine(params);
        return engine;
    }

    private static final GeneratedEngineFactory getInstance(String name) {
        GeneratedEngineFactory instance = null;
        ServiceLoader<GeneratedEngineFactory> loader = ServiceLoader.load(GeneratedEngineFactory.class);
        if (name != null) {
            for (GeneratedEngineFactory factory : loader) {
                if (!name.equals(factory.getName())) continue;
                instance = factory;
                break;
            }
        } else {
            instance = GeneratedEngineFactory.getInstance(DEFAULT_ENGINE_NAME);
        }
        if (instance == null) {
            throw new IllegalArgumentException(name + " is invalid engine name!");
        }
        return instance;
    }

    public static final Stream<String> registeredEngineNames() {
        ArrayList<String> names = new ArrayList<String>();
        ServiceLoader<GeneratedEngineFactory> serviceLoader = ServiceLoader.load(GeneratedEngineFactory.class);
        for (GeneratedEngineFactory factory : serviceLoader) {
            names.add(factory.getName());
        }
        return names.stream();
    }
}

