/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.generated.common.Context;
import tech.generated.common.FillerFactory;
import tech.generated.common.GeneratedEngine;
import tech.generated.common.InstanceBuilderFactory;
import tech.generated.common.NewInstanceException;
import tech.generated.common.engine.reflect.Accessor;
import tech.generated.common.engine.spi.summner.ComplexContext;
import tech.generated.common.engine.spi.summner.RefFieldContext;
import tech.generated.common.engine.spi.summner.ValFieldContext;
import tech.generated.common.engine.spi.summner.ValueContext;
import tech.generated.common.util.Util;

public class DefaultFiller<T>
implements Function<T, T> {
    private final ValueContext<T> context;
    private final Collection<String> skippedFields = new HashSet<String>();

    public DefaultFiller(ValueContext<T> context) {
        this.context = context;
    }

    @Override
    public T apply(T object) {
        if (!this.context.isActiveted()) {
            if (object != null && !Util.isSimple(object.getClass())) {
                this.fillObject(object);
            }
            this.context.setActiveted(true);
        }
        return object;
    }

    private void fillObject(T object) {
        DefaultFiller.prepareClassHierarchy(object.getClass()).forEach(c -> this.fill((Class<T>)c, object));
    }

    private <T> void fill(Class<T> clazz, Object object) {
        this.preapreFieldsForFilling(clazz).forEach(this::fill);
    }

    private <F> Context<F> fill(Accessor<F> accessor) throws NewInstanceException {
        GeneratedEngine engine = this.context.getGeneratedEngine();
        InstanceBuilderFactory instanceBuilderFactory = engine.instanceBuilderFactory();
        FillerFactory fillerFactory = engine.fillerFactory();
        Supplier instanceBuilder = instanceBuilderFactory.builder((ValueContext)accessor);
        Object object = instanceBuilder.get();
        accessor.set(object);
        Function filler = fillerFactory.filler((ValueContext)accessor);
        object = filler.apply(object);
        accessor.set(object);
        return (Context)((Object)accessor);
    }

    private Stream<Accessor<?>> preapreFieldsForFilling(Class<?> clazz) {
        return this.prepareActualFields(clazz).map(f -> f.getType().isPrimitive() ? new ValFieldContext((ComplexContext)this.context, (Field)f) : new RefFieldContext((ComplexContext)this.context, (Field)f));
    }

    private Stream<Field> prepareActualFields(Class<?> clazz) {
        return this.prepareDeclaredFields(clazz).filter(f -> !this.skippedFields.contains(f.getName()));
    }

    private Stream<Field> prepareDeclaredFields(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredFields()).stream();
    }

    private static Stream<Class<?>> prepareClassHierarchy(Class<?> clazz) {
        ArrayDeque stack = new ArrayDeque(5);
        do {
            stack.push(clazz);
        } while ((clazz = clazz.getSuperclass()) != null);
        return stack.stream();
    }

    public void addSkippedField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null!");
        }
        this.skippedFields.add(name);
    }

    public void removeSkippedField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null!");
        }
        this.skippedFields.remove(name);
    }
}

