/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.generated.common.Context;
import tech.generated.common.GeneratedEngine;
import tech.generated.common.annotation.Filler;
import tech.generated.common.annotation.ForClass;
import tech.generated.common.annotation.InstanceBuilder;
import tech.generated.common.engine.spi.summner.Core;
import tech.generated.common.engine.spi.summner.DefaultFiller;
import tech.generated.common.engine.spi.summner.NameGenerator;
import tech.generated.common.engine.spi.summner.ValueContext;
import tech.generated.common.engine.spi.summner.annotation.AnnotationListener;
import tech.generated.common.engine.spi.summner.annotation.AnnotationProcessor;
import tech.generated.common.engine.spi.summner.annotation.CoreImpl;
import tech.generated.common.engine.spi.summner.path.ClassAssignableFromSelector;
import tech.generated.common.engine.spi.summner.path.ClassEqualsSelector;
import tech.generated.common.engine.spi.summner.path.CommonValueMatchSelector;
import tech.generated.common.engine.spi.summner.path.ConnectToParentWrapperSelector;
import tech.generated.common.path.Selector;
import tech.generated.common.util.Util;

public class AnnotationBasedCoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationBasedCoreBuilder.class);
    private static final Predicate<Method> METHOD_PREDICATE_INSTANCE_BUILDER = method -> {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return method.getAnnotation(InstanceBuilder.class) != null && Modifier.isPublic(method.getModifiers()) && (parameterTypes.length == 0 || parameterTypes.length == 1 && Context.class.isAssignableFrom(parameterTypes[0]));
    };
    private static final Predicate<Method> METHOD_PREDICATE_FILLER = method -> {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return method.getAnnotation(InstanceBuilder.class) != null || Modifier.isPublic(method.getModifiers()) && method.getAnnotation(Filler.class) != null;
    };
    private final GeneratedEngine generatedEngine;

    public AnnotationBasedCoreBuilder(GeneratedEngine generatedEngine) {
        this.generatedEngine = generatedEngine;
    }

    public Core build(Object configuration) {
        final CoreImpl core = new CoreImpl();
        AnnotationListener listener = new AnnotationListener(){

            @Override
            public void fireInstanceBuilder(Selector<Context<?>> selector, Function<Context<?>, ?> function) {
                core.add(selector, function);
            }

            @Override
            public <T> void fireFiller(Selector<Context<?>> selector, BiFunction<Context<?>, ?, ?> function) {
                core.add(selector, function);
            }
        };
        this.instancebuilders(configuration).forEach(p -> listener.fireInstanceBuilder((Selector)p.getLeft(), (Function)p.getRight()));
        this.fillers(configuration).forEach(p -> listener.fireFiller((Selector)p.getLeft(), (BiFunction)p.getRight()));
        return core;
    }

    private Stream<Pair<Selector<Context<?>>, Function<Context<?>, ?>>> instancebuilders(Object configuration) {
        return this.streamOfMethods(configuration.getClass(), METHOD_PREDICATE_INSTANCE_BUILDER).map(m -> this.instanceBuilder(configuration, (Method)m));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Selector<Context<?>>, Function<Context<?>, ?>> instanceBuilder(Object configuration, Method method) {
        Function<Context, Object> function;
        if (method.getAnnotation(InstanceBuilder.class) == null) throw new IllegalArgumentException("Method " + method + " maust be annotaited by " + InstanceBuilder.class + " annotation!");
        Class<?>[] paramTypes = method.getParameterTypes();
        if (Supplier.class.isAssignableFrom(method.getReturnType())) {
            if (paramTypes.length == 0) {
                function = context -> {
                    try {
                        return ((Supplier)method.invoke(configuration, new Object[0])).get();
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
                return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
            } else {
                if (paramTypes.length != 1 || !Context.class.isAssignableFrom(paramTypes[0])) throw new IllegalArgumentException("Method " + method + "must have signature 'Function function()' or 'Function function(" + Context.class + ")'!");
                function = context -> {
                    try {
                        return ((Supplier)method.invoke(configuration, context)).get();
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
        } else if (paramTypes.length == 0) {
            function = context -> {
                try {
                    return Util.invoke(configuration, method, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
        } else {
            if (paramTypes.length != 1 || !Context.class.isAssignableFrom(paramTypes[0])) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
            function = context -> {
                try {
                    return Util.invoke(configuration, method, context);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
    }

    private Stream<Pair<Selector<Context<?>>, BiFunction<Context<?>, ?, ?>>> fillers(Object configuration) {
        return this.streamOfMethods(configuration.getClass(), METHOD_PREDICATE_FILLER).map(m -> this.filler(configuration, (Method)m));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Selector<Context<?>>, BiFunction<Context<?>, ?, ?>> filler(Object configuration, Method method) {
        BiFunction<Context, Object, Object> function;
        if (method.getAnnotation(InstanceBuilder.class) == null) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (Function.class.isAssignableFrom(method.getReturnType())) {
                if (paramTypes.length == 0) {
                    function = (context, object) -> ((Function)Util.invoke(configuration, method, new Object[0])).apply(object);
                    return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
                } else {
                    if (paramTypes.length != 1 || !Context.class.isAssignableFrom(paramTypes[0])) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
                    function = (context, object) -> ((Function)Util.invoke(configuration, method, context)).apply(object);
                }
                return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
            } else {
                if (paramTypes.length <= 0 || paramTypes.length >= 3) throw new IllegalArgumentException("Method " + method + " must have signature: '? function(? object, " + Context.class + " context)' or '? function(" + Context.class + " context, ? object)'!");
                if (paramTypes.length == 1) {
                    function = (context, object) -> {
                        try {
                            return Util.invoke(configuration, method, object);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                    return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
                } else if (Context.class.isAssignableFrom(paramTypes[0])) {
                    function = (context, object) -> {
                        try {
                            return Util.invoke(configuration, method, context, object);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                    return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
                } else {
                    if (!Context.class.isAssignableFrom(paramTypes[1])) throw new IllegalArgumentException("Method " + method + " must have signature: '? function(? object, " + Context.class + " context)' or '? function(" + Context.class + " context, ? object)'!");
                    function = (context, object) -> {
                        try {
                            return Util.invoke(configuration, method, object, context);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
            }
            return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
        } else {
            function = method.getAnnotation(InstanceBuilder.class).simple() ? (context, object) -> object : (context, object) -> new DefaultFiller<Object>((ValueContext)context).apply(object);
        }
        return Pair.of(this.selectors(configuration, method).findFirst().get(), function);
    }

    private Stream<Selector<Context<?>>> selectors(Object configuration, Method method) {
        return Stream.of(Stream.of(method.getAnnotations()).filter(a -> !(a instanceof InstanceBuilder) && !(a instanceof Filler) && !(a instanceof ForClass)).map(a -> AnnotationProcessor.get(a).map(p -> p.process(this, configuration, method, (Annotation)a)).orElse(null)).filter(e -> e != null && e instanceof Selector).map(e -> (Selector)e).reduce(this.getClassSelector(configuration, method), (l, r) -> l != null ? ConnectToParentWrapperSelector.of(l, r) : r));
    }

    private Selector<Context<?>> getClassSelector(Object configuration, Method method) {
        return Optional.ofNullable(method.getAnnotation(ForClass.class)).map(a -> {
            CommonValueMatchSelector selector = a.strict() ? new ClassEqualsSelector(a.name() != null ? a.name() : NameGenerator.nextName(), null, method.getAnnotation(InstanceBuilder.class) != null ? Long.MIN_VALUE : a.metrics(), a.value()) : new ClassAssignableFromSelector(a.name() != null ? a.name() : NameGenerator.nextName(), null, method.getAnnotation(InstanceBuilder.class) != null ? Long.MIN_VALUE : a.metrics(), a.value());
            return selector;
        }).orElseGet(() -> new ClassEqualsSelector(NameGenerator.nextName(), null, Long.MIN_VALUE, this.of(method)));
    }

    private Class<?> of(Method method) {
        Class result;
        if (method.getAnnotation(InstanceBuilder.class) != null) {
            result = Optional.of(method.getReturnType()).map(c -> {
                Class<?> clazz = Supplier.class.isAssignableFrom((Class<?>)c) ? Util.getSupplierReturnType((Class<? extends Supplier>)c) : c;
                return clazz;
            }).get();
        } else if (method.getAnnotation(Filler.class) != null) {
            result = Optional.of(method.getReturnType()).map(c -> {
                Class clazz = Function.class.isAssignableFrom((Class<?>)c) ? Util.getFunctionArgumentType(c) : Optional.of(method.getParameterCount()).map(count -> {
                    if (count > 0 && count < 3) {
                        return count == 1 || Context.class.isAssignableFrom(method.getParameterTypes()[1]) ? method.getParameterTypes()[0] : method.getParameterTypes()[1];
                    }
                    throw new IllegalArgumentException("Method " + method + " must have signature: '? function(? object, " + Context.class + " context)' or '? function(" + Context.class + " context, ? object)'!");
                }).get();
                return clazz;
            }).get();
        } else {
            throw new IllegalArgumentException("Method " + method + " must be annotated by " + InstanceBuilder.class + " or " + Filler.class + " annotation!");
        }
        return result;
    }

    private Stream<Method> streamOfMethods(Class<?> clazz, Predicate<Method> predicate) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return Stream.concat(this.streamOfMethods(superClass, predicate), Stream.of(clazz.getMethods()).filter(predicate));
        }
        return Stream.of(clazz.getMethods()).filter(predicate);
    }
}

