/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.generated.common.engine.spi.summner.annotation.AnnotationBasedCoreBuilder;

public abstract class AnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationProcessor.class);
    private static final Map<Class<? extends Annotation>, Optional<AnnotationProcessor>> ANNOTATION_PROCESSOR_MAP = new HashMap<Class<? extends Annotation>, Optional<AnnotationProcessor>>();

    public static Optional<AnnotationProcessor> get(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Optional<AnnotationProcessor> annotationProcessor = ANNOTATION_PROCESSOR_MAP.get(clazz);
        if (annotationProcessor == null) {
            LOG.warn("There is no annotation processor for '" + clazz + "!");
            annotationProcessor = Optional.empty();
        }
        return annotationProcessor;
    }

    public abstract long metrics();

    public abstract Object process(AnnotationBasedCoreBuilder var1, Object var2, Method var3, Annotation var4);

    public abstract Class<? extends Annotation> annotationClass();

    static {
        ServiceLoader<AnnotationProcessor> serviceLoader = ServiceLoader.load(AnnotationProcessor.class);
        for (AnnotationProcessor processor : serviceLoader) {
            ANNOTATION_PROCESSOR_MAP.put(processor.annotationClass(), Optional.of(processor));
            LOG.info("Annotation processor '{}' for class '{}' loaded!", (Object)processor, processor.annotationClass());
        }
    }
}

