/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.path;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import tech.generated.common.path.Path;

public interface Selector<P extends Path<?, ? extends P>>
extends Predicate<P>,
Cloneable {
    public String name();

    public Selector<P> next();

    public long metrics();

    default public Stream<Selector<P>> chain() {
        Iterator iterator = new Iterator<Selector<P>>(){
            private Selector<P> nextElement;
            {
                this.nextElement = Selector.this;
            }

            @Override
            public boolean hasNext() {
                return this.nextElement != null;
            }

            @Override
            public Selector<P> next() {
                try {
                    Selector selector = this.nextElement;
                    return selector;
                }
                finally {
                    this.nextElement = this.nextElement.next();
                }
            }
        };
        Spliterator selectorSpliterator = Spliterators.spliteratorUnknownSize(iterator, 1280);
        return StreamSupport.stream(selectorSpliterator, false);
    }

    public Selector<P> clone() throws CloneNotSupportedException;
}

