/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.loly;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;
import tech.generated.Filler;
import tech.generated.InstanceBuilder;
import tech.generated.configuration.dsl.Configuration;
import tech.generated.configuration.dsl.Custom;
import tech.generated.configuration.dsl.NonStrict;
import tech.generated.configuration.dsl.Path;
import tech.generated.configuration.dsl.Selectable;
import tech.generated.configuration.dsl.Strict;
import tech.generated.loly.CustomSelector;
import tech.generated.loly.NonStrictClassSelector;
import tech.generated.loly.PathSelectorBuilder;
import tech.generated.loly.Selector;
import tech.generated.loly.StrictClassSelector;
import tech.generated.loly.UnitFiller;

final class BConfiguration {
    private final Collection<Selector> instanceBuilderSelectors;
    private final Map<Selector, InstanceBuilder<?>> instanceBuilderMap;
    private final Collection<Selector> fillerSelectors;
    private final Map<Selector, Filler<?>> fillerMap;

    private BConfiguration(Map<Selector, InstanceBuilder<?>> instanceBuilderMap, Map<Selector, Filler<?>> fillerMap) {
        this.instanceBuilderMap = Collections.unmodifiableMap(Objects.requireNonNull(instanceBuilderMap));
        this.instanceBuilderSelectors = Collections.unmodifiableCollection(this.instanceBuilderMap.keySet());
        this.fillerMap = Collections.unmodifiableMap(Objects.requireNonNull(fillerMap));
        this.fillerSelectors = Collections.unmodifiableCollection(this.fillerMap.keySet());
    }

    public Stream<Selector> getInstanceBuilderSelectors() {
        return this.instanceBuilderSelectors.stream();
    }

    public Stream<Selector> getFillerSelectors() {
        return this.fillerSelectors.stream();
    }

    public <T> InstanceBuilder<T> getInstanceBuilder(Selector selector) {
        return this.instanceBuilderMap.get(selector);
    }

    public <T> Filler<T> getFiller(Selector selector) {
        return this.fillerMap.get(selector);
    }

    public static BConfiguration build(Configuration configuration) {
        HashMap instanceBuilderMap = new HashMap();
        HashMap fillerMap = new HashMap();
        Objects.requireNonNull(configuration).selectables().stream().map(BConfiguration::selectable).forEach(e -> {
            Selector selector = (Selector)e.getLeft();
            InstanceBuilder instanceBuilder = (InstanceBuilder)e.getMiddle();
            Filler filler = (Filler)e.getRight();
            if (instanceBuilder != null) {
                instanceBuilderMap.put(selector, instanceBuilder);
            }
            if (filler != null) {
                fillerMap.put(selector, filler);
            }
        });
        return new BConfiguration(instanceBuilderMap, fillerMap);
    }

    private static Triple<Selector, InstanceBuilder, Filler> selectable(Selectable selectable) {
        Triple result;
        Selector selector = BConfiguration.selector(selectable.selector());
        Object function = selectable.function();
        if (function instanceof InstanceBuilder) {
            result = selectable.isSimple() ? Triple.of((Object)selector, (Object)((InstanceBuilder)function), new UnitFiller()) : Triple.of((Object)selector, (Object)((InstanceBuilder)function), null);
        } else if (function instanceof Filler) {
            result = selectable.isSimple() ? Triple.of((Object)selector, null, new UnitFiller()) : Triple.of((Object)selector, null, (Object)((Filler)function));
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static Selector selector(tech.generated.configuration.dsl.Selector selector) {
        return selector != null ? BConfiguration.selector(selector, BConfiguration.selector(selector.next())) : null;
    }

    private static Selector selector(tech.generated.configuration.dsl.Selector selector, Selector next) {
        Selector result;
        if (selector instanceof Strict) {
            result = new StrictClassSelector(selector.name(), selector.metrics(), next, ((Strict)selector).clazz());
        } else if (selector instanceof NonStrict) {
            result = new NonStrictClassSelector(selector.name(), selector.metrics(), next, ((NonStrict)selector).clazz());
        } else if (selector instanceof Custom) {
            result = new CustomSelector(selector.name(), selector.metrics(), next, (Custom)selector);
        } else if (selector instanceof Path) {
            result = PathSelectorBuilder.build(selector, next);
        } else {
            throw new IllegalArgumentException("'" + selector + "' is illegal selector!");
        }
        return result;
    }
}

