/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.loly;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import tech.generated.Context;
import tech.generated.loly.AsBoxed;
import tech.generated.loly.Selector;

abstract class ClassSelector<T, B extends ClassSelector<?, ?>>
extends Selector
implements AsBoxed<B> {
    private static ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static Lock LOCK_READ = LOCK.readLock();
    private static Lock LOCK_WRITE = LOCK.writeLock();
    private B boxed;
    private final Supplier<B> boxedProducer;

    protected ClassSelector(String name, Function<Context<?>, Integer> metrics, Selector next, Predicate<Context<?>> predicate, Supplier<B> boxedProducer) {
        super(name, metrics, next, predicate);
        this.boxedProducer = Objects.requireNonNull(boxedProducer);
    }

    @Override
    public B asBoxed() {
        try {
            LOCK_READ.lock();
            if (this.boxed == null) {
                try {
                    LOCK_READ.unlock();
                    LOCK_WRITE.lock();
                    this.boxed = (ClassSelector)this.boxedProducer.get();
                    LOCK_READ.lock();
                }
                finally {
                    LOCK_WRITE.unlock();
                }
            }
            B b = this.boxed;
            return b;
        }
        finally {
            LOCK_READ.unlock();
        }
    }
}

