/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.loly;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.generated.Context;
import tech.generated.Filler;
import tech.generated.InstanceBuilder;
import tech.generated.loly.LolyObjectFactory;
import tech.generated.loly.context.RefFieldContext;
import tech.generated.loly.context.Stage;
import tech.generated.loly.context.ValFieldContext;
import tech.generated.loly.context.ValueContext;
import tech.generated.loly.reflect.Accessor;
import tech.generated.util.Stream;

class DefaultFiller<T>
implements Filler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFiller.class);
    private Collection<String> skippedFieldNames = new HashSet<String>();
    private final ValueContext<T> context;
    private final LolyObjectFactory objectFactory;

    public DefaultFiller(LolyObjectFactory objectFactory, ValueContext<T> context) {
        this.context = context;
        this.objectFactory = objectFactory;
    }

    public T apply(Context<T> context, T object) {
        this.classes(this.context.clazz()).flatMap(this::accessors).forEach(this::fill);
        return object;
    }

    private <T> void fill(Accessor<T> accessor) {
        ValueContext context = (ValueContext)accessor;
        if (context.getStage() != Stage.COMPLETE) {
            InstanceBuilder instanceBuilder = this.objectFactory.instanceBuilder(context);
            Filler filler = this.objectFactory.filler(context);
            Object object = instanceBuilder.apply((Object)context);
            accessor.set(object);
            context.setStage(Stage.INITIALIZATION);
            accessor.set(filler.apply((Object)context, object));
            context.setStage(Stage.COMPLETE);
        }
    }

    private java.util.stream.Stream<Accessor<?>> accessors(Class<?> clazz) {
        return this.fieldAccessors(clazz);
    }

    private java.util.stream.Stream<Accessor<?>> fieldAccessors(Class<?> clazz) {
        return java.util.stream.Stream.of(clazz.getDeclaredFields()).filter(f -> !this.skippedFieldNames.contains(f.getName())).map(f -> f.getType().isPrimitive() ? new ValFieldContext(this.context, (Field)f) : new RefFieldContext(this.context, (Field)f));
    }

    private java.util.stream.Stream<Class<?>> classes(Class<?> clazz) {
        return Stream.of(clazz, Class::getSuperclass);
    }
}

