/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.loly;

import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import tech.generated.Context;
import tech.generated.Filler;
import tech.generated.InstanceBuilder;
import tech.generated.ObjectContext;
import tech.generated.ObjectFactory;
import tech.generated.Spec;
import tech.generated.Util;
import tech.generated.loly.AsBoxed;
import tech.generated.loly.BConfiguration;
import tech.generated.loly.DefaultFiller;
import tech.generated.loly.DefaultInstanceBuilder;
import tech.generated.loly.Selector;
import tech.generated.loly.UnitFiller;
import tech.generated.loly.context.Stage;
import tech.generated.loly.context.ValueContext;

final class LolyObjectFactory
implements ObjectFactory {
    private final BConfiguration configuration;

    public LolyObjectFactory(BConfiguration configuration) {
        this.configuration = configuration;
    }

    public <T> ObjectContext<T> build(Spec<T> initContext) {
        tech.generated.loly.context.ObjectContext<Object> context = new tech.generated.loly.context.ObjectContext<Object>(initContext.bindings(), initContext.clazz());
        InstanceBuilder instanceBuilder = this.instanceBuilder(context);
        Object filler = Util.isSimple(context.clazz()) ? new UnitFiller() : new DefaultFiller(this, context);
        Object object = instanceBuilder.apply(context);
        context.set(object);
        context.setStage(Stage.INITIALIZATION);
        context.set(filler.apply(context, object));
        context.setStage(Stage.COMPLETE);
        return context;
    }

    public <T> InstanceBuilder<T> instanceBuilder(Context<T> context) {
        Collection candidates = this.configuration.getInstanceBuilderSelectors().filter(s -> s.test(context)).collect(Collectors.toList());
        if (candidates.isEmpty() && Util.isBoxing(context.clazz())) {
            candidates = this.configuration.getInstanceBuilderSelectors().filter(s -> s instanceof AsBoxed && ((Selector)((AsBoxed)((Object)s)).asBoxed()).test(context)).collect(Collectors.toList());
        }
        return candidates.stream().max(Comparator.comparing(s -> s.metrics().apply(context))).map(s -> this.configuration.getInstanceBuilder((Selector)s)).orElse(new DefaultInstanceBuilder(context.clazz()));
    }

    public <T> Filler<T> filler(Context<T> context) {
        Collection candidates = this.configuration.getFillerSelectors().filter(s -> s.test(context)).collect(Collectors.toList());
        if (candidates.isEmpty() && Util.isBoxing(context.clazz())) {
            candidates = this.configuration.getFillerSelectors().filter(s -> s.test(context)).collect(Collectors.toList());
        }
        return candidates.stream().max(Comparator.comparing(s -> s.metrics().apply(context))).map(s -> this.configuration.getFiller((Selector)s)).orElse((Filler)(Util.isSimple(context.clazz()) ? new UnitFiller() : new DefaultFiller(this, (ValueContext)context)));
    }
}

