/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.loly;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import tech.generated.Context;
import tech.generated.configuration.dsl.Path;
import tech.generated.loly.MatchedNameSelector;
import tech.generated.loly.NameEqualsSelector;
import tech.generated.loly.PathBaseListener;
import tech.generated.loly.PathLexer;
import tech.generated.loly.PathParser;
import tech.generated.loly.RootMatchSelector;
import tech.generated.loly.Selector;
import tech.generated.loly.SkipSelector;

final class PathSelectorBuilder {
    private static final Function<Context<?>, Integer> ZERO = c -> 0;
    private static final Function<Context<?>, Integer> UNIT = c -> 1;

    public static Selector build(tech.generated.configuration.dsl.Selector path, Selector next) {
        CodePointCharStream stream = CharStreams.fromString((String)((Path)path).path());
        PathLexer lexer = new PathLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        PathParser parser = new PathParser((TokenStream)tokenStream);
        ParseTreeWalker walker = new ParseTreeWalker();
        Listener listener = new Listener(path.name(), path.metrics(), next);
        walker.walk((ParseTreeListener)listener, (ParseTree)parser.path());
        return listener.last;
    }

    private PathSelectorBuilder() {
    }

    private static class Listener
    extends PathBaseListener {
        private static final int UNDEFINED = -1;
        private final String name;
        private final Function<Context<?>, Integer> metrics;
        private int index = 0;
        private int skipCount = -1;
        private Selector last;

        public Listener(String name, Function<Context<?>, Integer> metrics, Selector next) {
            this.name = name;
            this.metrics = metrics;
            this.last = next;
        }

        @Override
        public void enterRoot(PathParser.RootContext ctx) {
            this.last = new RootMatchSelector(this.name, this.metrics != null ? this.metrics : UNIT, this.last);
        }

        @Override
        public void enterName(PathParser.NameContext ctx) {
            this.last = new NameEqualsSelector(this.name + this.index++, this.metrics != null ? ZERO : UNIT, this.last, ctx.getText());
        }

        @Override
        public void enterMatchedName(PathParser.MatchedNameContext ctx) {
            this.last = new MatchedNameSelector(this.name + this.index++, this.metrics != null ? ZERO : UNIT, this.last, Pattern.compile(ctx.getText().replace("*", ".*")));
        }

        @Override
        public void enterSkip(PathParser.SkipContext ctx) {
            this.skipCount = 0;
        }

        @Override
        public void exitSkip(PathParser.SkipContext ctx) {
            this.last = new SkipSelector(this.name + this.index++, this.metrics != null ? ZERO : c -> this.skipCount, this.last, this.skipCount);
            this.skipCount = -1;
        }

        @Override
        public void exitSkipElememt(PathParser.SkipElememtContext ctx) {
            if (this.skipCount < 0) {
                throw new IllegalStateException("skipCount not initialized!");
            }
            this.skipCount += ctx.SKIP_NAME_COUNT() != null ? Integer.parseInt(ctx.SKIP_NAME_COUNT().getText()) : 1;
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
            throw new RuntimeException("Unexpected string: '" + node.getText() + "'");
        }
    }
}

