/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.loly;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import tech.generated.Context;

abstract class Selector
implements Predicate<Context<?>> {
    private String name;
    private Function<Context<?>, Integer> metrics;
    private Selector next;
    private Predicate<Context<?>> predicate;

    protected Selector(String name, Function<Context<?>, Integer> metrics, Selector next, Predicate<Context<?>> predicate) {
        this.name = Objects.requireNonNull(name);
        this.metrics = metrics;
        this.next = next;
        this.predicate = Objects.requireNonNull(predicate);
    }

    public String name() {
        return this.name;
    }

    public Function<Context<?>, Integer> metrics() {
        return this.metrics;
    }

    public Selector next() {
        return this.next;
    }

    @Override
    public final boolean test(Context<?> context) {
        return this.predicate.test(context) && (this.next == null || this.next.test(context));
    }
}

