/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import tech.grasshopper.exception.CucumberRestAssuredExtentReportPluginException;
import tech.grasshopper.extent.pojo.HttpDetails;
import tech.grasshopper.extent.reports.ReportCreator;
import tech.grasshopper.logging.ReportLogger;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.processor.CucumberAllureDataProcessor;
import tech.grasshopper.processor.HttpDataProcessor;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.ra.pojo.Result;
import tech.grasshopper.results.AllureResultsCollector;
import tech.grasshopper.results.CucumberAllureMappingCollector;
import tech.grasshopper.results.CucumberResultsCollector;

@Mojo(name="extentreport")
public class CucumberRestAssuredExtentReportPlugin
extends AbstractMojo {
    @Parameter(property="extentreport.cucumberReportsDirectory", defaultValue="target")
    private String cucumberReportsDirectory;
    @Parameter(property="extentreport.allureResultsDirectory", defaultValue="target/allure-results")
    private String allureResultsDirectory;
    @Parameter(property="extentreport.cucumberAllureMappingFile", defaultValue="target/cucumber-allure.json")
    private String cucumberAllureMappingFile;
    @Parameter(property="extentreport.reportDirectory", defaultValue="report")
    private String reportDirectory;
    @Parameter(property="extentreport.reportDirectoryTimeStamp", defaultValue="dd MM yyyy HH mm ss")
    private String reportDirectoryTimeStamp;
    @Parameter(property="extentreport.sparkGenerate", defaultValue="true")
    private boolean sparkGenerate;
    @Parameter(property="extentreport.sparkConfigFilePath", defaultValue="src/test/resources/spark-config.xml")
    private String sparkConfigFilePath;
    @Parameter(property="extentreport.pdfGenerate", defaultValue="true")
    private boolean pdfGenerate;
    @Parameter(property="extentreport.pdfConfigFilePath", defaultValue="src/test/resources/pdf-config.xml")
    private String pdfConfigFilePath;
    @Parameter(property="extentreport.systemInfoFilePath", defaultValue="src/test/resources/systeminfo.properties")
    private String systemInfoFilePath;
    @Parameter(property="extentreport.sparkViewOrder")
    private String sparkViewOrder;
    private CucumberResultsCollector cucumberResultsCollector;
    private AllureResultsCollector allureResultsCollector;
    private CucumberAllureMappingCollector cucumberAllureMappingCollector;
    private CucumberAllureDataProcessor cucumberAllureDataProcessor;
    private HttpDataProcessor httpDataProcessor;
    private ReportCreator reportCreator;
    private ReportProperties reportProperties;
    private ReportLogger logger;

    @Inject
    public CucumberRestAssuredExtentReportPlugin(CucumberResultsCollector cucumberResultsCollector, AllureResultsCollector allureResultsCollector, CucumberAllureMappingCollector cucumberAllureMappingCollector, CucumberAllureDataProcessor cucumberAllureDataProcessor, HttpDataProcessor httpDataProcessor, ReportCreator reportCreator, ReportProperties reportProperties, ReportLogger logger) {
        this.cucumberResultsCollector = cucumberResultsCollector;
        this.allureResultsCollector = allureResultsCollector;
        this.cucumberAllureMappingCollector = cucumberAllureMappingCollector;
        this.cucumberAllureDataProcessor = cucumberAllureDataProcessor;
        this.httpDataProcessor = httpDataProcessor;
        this.reportCreator = reportCreator;
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public void execute() {
        try {
            this.logger.initializeLogger(this.getLog());
            this.logger.info("STARTING EXTENT REPORT GENERATION");
            this.setReportProperties();
            if (!this.reportProperties.isSparkGenerate() && !this.reportProperties.isPdfGenerate()) {
                this.logger.info("STOPPING EXTENT REPORT GENERATION - No report type selected.");
                return;
            }
            this.createAttachmentFolder();
            List<Feature> features = this.cucumberResultsCollector.retrieveFeatures(this.reportProperties.getCucumberReportsDirectory());
            List<Result> results = this.allureResultsCollector.retrieveResults(this.reportProperties.getAllureResultsDirectory());
            List<HttpDetails> httpDetailsData = this.httpDataProcessor.process(results);
            Map<String, String> mapping = this.cucumberAllureMappingCollector.retrieveMapping(this.cucumberAllureMappingFile);
            this.cucumberAllureDataProcessor.process(features, httpDetailsData, mapping);
            this.reportCreator.generate(features);
            this.logger.info("EXTENT REPORT SUCCESSFULLY GENERATED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.logger.error(String.format("STOPPING EXTENT REPORT GENERATION - %s", t.getMessage()));
        }
    }

    private void setReportProperties() {
        this.reportProperties.setCucumberReportsDirectory(this.cucumberReportsDirectory);
        this.reportProperties.setAllureResultsDirectory(this.allureResultsDirectory);
        this.reportProperties.setReportDirectory(this.reportDirectory, this.reportDirectoryTimeStamp);
        this.reportProperties.setSystemInfoFilePath(this.systemInfoFilePath);
        this.reportProperties.setSparkGenerate(this.sparkGenerate);
        this.reportProperties.setSparkConfigFilePath(this.sparkConfigFilePath);
        this.reportProperties.setSparkViewOrder(this.sparkViewOrder);
        this.reportProperties.setPdfGenerate(this.pdfGenerate);
        this.reportProperties.setPdfConfigFilePath(this.pdfConfigFilePath);
    }

    private void createAttachmentFolder() {
        try {
            Files.createDirectories(Paths.get(this.reportProperties.getReportDirectory(), "data"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CucumberRestAssuredExtentReportPluginException("Unable to create report attachments directory.", e);
        }
    }
}

