/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.reports;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import com.aventstack.extentreports.reporter.configuration.ViewName;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.logging.ReportLogger;
import tech.grasshopper.pdf.extent.RestAssuredExtentPDFCucumberReporter;
import tech.grasshopper.properties.ReportProperties;

@Singleton
public class ReportInitializer {
    private ReportProperties reportProperties;
    private ReportLogger logger;

    @Inject
    public ReportInitializer(ReportProperties reportProperties, ReportLogger logger) {
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public ExtentReports initialize() {
        ExtentReports extent = new ExtentReports();
        extent.setAnalysisStrategy(AnalysisStrategy.BDD);
        extent.setReportUsesManualConfiguration(true);
        this.addSystemInfoProperties(extent);
        if (this.reportProperties.isSparkGenerate()) {
            this.initializeSparkReport(extent);
        }
        if (this.reportProperties.isPdfGenerate()) {
            this.initializePdfReport(extent);
        }
        return extent;
    }

    private void addSystemInfoProperties(ExtentReports extent) {
        String systemInfoFilePath = this.reportProperties.getSystemInfoFilePath();
        if (systemInfoFilePath == null || systemInfoFilePath.indexOf(46) == -1 || !Files.exists(Paths.get(systemInfoFilePath, new String[0]), new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        try {
            FileInputStream is = new FileInputStream(systemInfoFilePath);
            properties.load(is);
        }
        catch (IOException e) {
            this.logger.info("Unable to load system info properties. No system info data available.");
            return;
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> extent.setSystemInfo(String.valueOf(k), String.valueOf(v))));
    }

    private ExtentSparkReporter initializeSparkReport(ExtentReports extent) {
        ExtentSparkReporter spark = new ExtentSparkReporter(Paths.get(this.reportProperties.getReportDirectory(), "SparkReport.html").toString());
        extent.attachReporter(new ExtentObserver[]{spark});
        try {
            this.loadConfigFile((ReporterConfigurable)spark, this.reportProperties.getSparkConfigFilePath());
        }
        catch (Exception e) {
            this.logger.info("Unable to locate spark configuration. Creating report with default settings.");
        }
        this.customizeViewOrder(spark);
        return spark;
    }

    private void loadConfigFile(ReporterConfigurable report, String configFilePath) throws IOException {
        if (configFilePath == null || configFilePath.indexOf(46) == -1 || !Files.exists(Paths.get(configFilePath, new String[0]), new LinkOption[0])) {
            return;
        }
        String configExt = configFilePath.substring(configFilePath.lastIndexOf(46) + 1);
        if (configExt.equalsIgnoreCase("xml")) {
            report.loadXMLConfig(configFilePath);
        } else if (configExt.equalsIgnoreCase("json")) {
            report.loadJSONConfig(configFilePath);
        }
    }

    private void customizeViewOrder(ExtentSparkReporter spark) {
        if (this.reportProperties.getSparkViewOrder() == null) {
            return;
        }
        try {
            List viewOrder = Arrays.stream(this.reportProperties.getSparkViewOrder().split(",")).map(v -> ViewName.valueOf((String)v.trim().toUpperCase())).collect(Collectors.toList());
            spark.viewConfigurer().viewOrder().as(viewOrder).apply();
        }
        catch (Exception e) {
            this.logger.info("Unable to customize Spark report view order. Creating report with default view order.");
        }
    }

    private RestAssuredExtentPDFCucumberReporter initializePdfReport(ExtentReports extent) {
        RestAssuredExtentPDFCucumberReporter pdf = new RestAssuredExtentPDFCucumberReporter(Paths.get(this.reportProperties.getReportDirectory(), "PdfReport.pdf").toString());
        extent.attachReporter(new ExtentObserver[]{pdf});
        return pdf;
    }
}

