/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.extent.pojo.HttpDetails;
import tech.grasshopper.processor.AttachmentProcessor;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.ra.pojo.Result;

@Singleton
public class HttpDataProcessor {
    private AttachmentProcessor attachmentProcessor;
    private ReportProperties reportProperties;

    @Inject
    public HttpDataProcessor(ReportProperties reportProperties) {
        this.reportProperties = reportProperties;
    }

    public List<HttpDetails> process(List<Result> results) {
        this.deleteExistingAttachmentFiles();
        this.attachmentProcessor = AttachmentProcessor.builder().allureResultsDirectory(this.reportProperties.getAllureResultsDirectory()).reportDirectory(this.reportProperties.getReportDirectory()).build();
        return results.stream().map(r -> this.transformResult((Result)r)).collect(Collectors.toList());
    }

    private void deleteExistingAttachmentFiles() {
        Path path = Paths.get(this.reportProperties.getReportDirectory(), "data");
        if (Files.exists(path, new LinkOption[0])) {
            Arrays.stream(new File(path.toString()).listFiles()).forEach(File::delete);
        }
    }

    private HttpDetails transformResult(Result result) {
        return HttpDetails.builder().name(result.getName()).uuid(result.getUuid()).dataLogs(this.attachmentProcessor.process(result.getAttachments())).build();
    }
}

