/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.cell;

import org.apache.logging.log4j.util.TriConsumer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.extent.data.pojo.Status;

public class CellOperations {
    private XSSFSheet sheet;
    public static final TriConsumer<CellOperations, CellReference, String> printString = CellOperations::writeStringValue;
    public static final TriConsumer<CellOperations, CellReference, String> printBoldString = CellOperations::writeBoldStringValue;
    public static final TriConsumer<CellOperations, CellReference, String> printLong = CellOperations::writePositiveNumericValue;
    public static final TriConsumer<CellOperations, CellReference, String> printStatus = CellOperations::writeStatus;

    public void writeStringValue(String cellName, String cellValue) {
        CellReference cellRef = new CellReference(cellName);
        this.writeStringValue(cellRef, cellValue);
    }

    public void writeStringValue(CellReference cellRef, String cellValue) {
        Cell cell = this.fetchOrCreateCell(cellRef);
        cell.setCellValue(cellValue);
    }

    public void writeBoldStringValue(CellReference cellRef, String cellValue) {
        Cell cell = this.fetchOrCreateCell(cellRef);
        CellStyle style = cell.getCellStyle();
        XSSFFont font = this.sheet.getWorkbook().createFont();
        font.setBold(true);
        style.setFont((Font)font);
        cell.setCellValue(cellValue);
    }

    public void writeStatus(CellReference cellRef, String status) {
        this.writeStatus(cellRef, Status.valueOf(status));
    }

    public void writeStatus(CellReference cellRef, Status status) {
        Cell cell = this.fetchOrCreateCell(cellRef);
        CellStyle style = cell.getCellStyle();
        XSSFFont font = this.sheet.getWorkbook().createFont();
        font.setColor(new XSSFColor(Status.getStatusColor(status), null));
        font.setBold(true);
        style.setFont((Font)font);
        cell.setCellValue(status.toString());
    }

    public void writeStringValueWithStatusColor(CellReference cellRef, String cellValue, Status status) {
        Cell cell = this.fetchOrCreateCell(cellRef);
        CellStyle style = cell.getCellStyle();
        XSSFFont font = this.sheet.getWorkbook().createFont();
        font.setColor(new XSSFColor(Status.getStatusColor(status), null));
        style.setFont((Font)font);
        cell.setCellValue(cellValue);
    }

    public void writeNumericValue(CellReference cellRef, String cellValue) {
        this.writeNumericValue(cellRef, (Long)Long.parseLong(cellValue));
    }

    public void writePositiveNumericValue(CellReference cellRef, String cellValue) {
        Long value = Long.parseLong(cellValue);
        this.writePositiveNumericValue(cellRef, value);
    }

    public void writePositiveNumericValue(String cellName, Long cellValue) {
        CellReference cellRef = new CellReference(cellName);
        this.writePositiveNumericValue(cellRef, cellValue);
    }

    public void writePositiveNumericValue(CellReference cellRef, Long cellValue) {
        Cell cell = this.fetchOrCreateCell(cellRef);
        if (cellValue > 0L) {
            cell.setCellValue((double)cellValue.longValue());
        } else {
            cell.setBlank();
        }
    }

    public void writeNumericValue(String cellName, Long cellValue) {
        CellReference cellRef = new CellReference(cellName);
        this.writeNumericValue(cellRef, cellValue);
    }

    public void writeNumericValue(CellReference cellRef, Long cellValue) {
        Cell cell = this.fetchOrCreateCell(cellRef);
        cell.setCellValue((double)cellValue.longValue());
    }

    private Cell fetchOrCreateCell(CellReference cellRef) {
        Cell cell;
        XSSFRow row = this.sheet.getRow(cellRef.getRow());
        if (row == null) {
            row = this.sheet.createRow(cellRef.getRow());
        }
        if ((cell = row.getCell((int)cellRef.getCol())) == null) {
            cell = row.createCell((int)cellRef.getCol());
        }
        return cell;
    }

    public void mergeRows(int startRow, int rowsToMerge, int startColumn, int colsToMerge) {
        if (rowsToMerge == 1 && colsToMerge == 1) {
            return;
        }
        this.sheet.addMergedRegion(new CellRangeAddress(startRow, startRow + rowsToMerge - 1, startColumn, startColumn + colsToMerge - 1));
    }

    public CellStyle createCellStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        return style;
    }

    public void createCellsWithStyleInRange(int startRow, int endRow, int startCol, int endCol) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startCol; j < endCol; ++j) {
                CellReference cellRef = new CellReference(i, j);
                Cell cell = this.fetchOrCreateCell(cellRef);
                CellStyle style = this.createCellStyle();
                cell.setCellStyle(style);
            }
        }
    }

    CellOperations(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public static CellOperationsBuilder builder() {
        return new CellOperationsBuilder();
    }

    public static class CellOperationsBuilder {
        private XSSFSheet sheet;

        CellOperationsBuilder() {
        }

        public CellOperationsBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public CellOperations build() {
            return new CellOperations(this.sheet);
        }

        public String toString() {
            return "CellOperations.CellOperationsBuilder(sheet=" + this.sheet + ")";
        }
    }
}

