/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets;

import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tech.grasshopper.extent.data.ReportData;

public abstract class Sheet {
    protected static final String DASHBOARD_SHEET = "Dashboard";
    protected static final String DASHBOARD_DATA_SHEET = "DB Data";
    protected static final String SCENARIOS_SHEET = "Scenarios";
    protected static final String TAGS_SHEET = "Tags";
    protected static final String FEATURES_SHEET = "Features";
    protected static final String EXCEPTIONS_SHEET = "Exceptions";
    protected static final String EXECUTION_SHEET = "Execution";
    protected static final int FREEZE_PANE_ROW = 20;
    protected ReportData reportData;
    protected XSSFWorkbook workbook;
    protected XSSFSheet sheet;

    public abstract void updateSheet();

    public void deleteSheet(String sheet) {
        this.workbook.removeSheetAt(this.workbook.getSheetIndex(sheet));
    }

    protected Sheet(SheetBuilder<?, ?> b) {
        this.reportData = ((SheetBuilder)b).reportData;
        this.workbook = ((SheetBuilder)b).workbook;
        this.sheet = ((SheetBuilder)b).sheet;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public XSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public XSSFSheet getSheet() {
        return this.sheet;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public void setWorkbook(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public void setSheet(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sheet)) {
            return false;
        }
        Sheet other = (Sheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReportData this$reportData = this.getReportData();
        ReportData other$reportData = other.getReportData();
        if (this$reportData == null ? other$reportData != null : !this$reportData.equals(other$reportData)) {
            return false;
        }
        XSSFWorkbook this$workbook = this.getWorkbook();
        XSSFWorkbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) {
            return false;
        }
        XSSFSheet this$sheet = this.getSheet();
        XSSFSheet other$sheet = other.getSheet();
        return !(this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReportData $reportData = this.getReportData();
        result = result * 59 + ($reportData == null ? 43 : $reportData.hashCode());
        XSSFWorkbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        XSSFSheet $sheet = this.getSheet();
        result = result * 59 + ($sheet == null ? 43 : $sheet.hashCode());
        return result;
    }

    public String toString() {
        return "Sheet(reportData=" + this.getReportData() + ", workbook=" + this.getWorkbook() + ", sheet=" + this.getSheet() + ")";
    }

    public static abstract class SheetBuilder<C extends Sheet, B extends SheetBuilder<C, B>> {
        private ReportData reportData;
        private XSSFWorkbook workbook;
        private XSSFSheet sheet;

        protected abstract B self();

        public abstract C build();

        public B reportData(ReportData reportData) {
            this.reportData = reportData;
            return this.self();
        }

        public B workbook(XSSFWorkbook workbook) {
            this.workbook = workbook;
            return this.self();
        }

        public B sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this.self();
        }

        public String toString() {
            return "Sheet.SheetBuilder(reportData=" + this.reportData + ", workbook=" + this.workbook + ", sheet=" + this.sheet + ")";
        }
    }
}

