/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.dashboard.components;

import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.extent.data.ReportData;

public abstract class DBComponent {
    protected XSSFSheet dbSheet;
    protected XSSFSheet dbDataSheet;
    protected ReportData reportData;

    public abstract void createComponent();

    protected DBComponent(DBComponentBuilder<?, ?> b) {
        this.dbSheet = ((DBComponentBuilder)b).dbSheet;
        this.dbDataSheet = ((DBComponentBuilder)b).dbDataSheet;
        this.reportData = ((DBComponentBuilder)b).reportData;
    }

    public XSSFSheet getDbSheet() {
        return this.dbSheet;
    }

    public XSSFSheet getDbDataSheet() {
        return this.dbDataSheet;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public void setDbSheet(XSSFSheet dbSheet) {
        this.dbSheet = dbSheet;
    }

    public void setDbDataSheet(XSSFSheet dbDataSheet) {
        this.dbDataSheet = dbDataSheet;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBComponent)) {
            return false;
        }
        DBComponent other = (DBComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XSSFSheet this$dbSheet = this.getDbSheet();
        XSSFSheet other$dbSheet = other.getDbSheet();
        if (this$dbSheet == null ? other$dbSheet != null : !this$dbSheet.equals(other$dbSheet)) {
            return false;
        }
        XSSFSheet this$dbDataSheet = this.getDbDataSheet();
        XSSFSheet other$dbDataSheet = other.getDbDataSheet();
        if (this$dbDataSheet == null ? other$dbDataSheet != null : !this$dbDataSheet.equals(other$dbDataSheet)) {
            return false;
        }
        ReportData this$reportData = this.getReportData();
        ReportData other$reportData = other.getReportData();
        return !(this$reportData == null ? other$reportData != null : !this$reportData.equals(other$reportData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XSSFSheet $dbSheet = this.getDbSheet();
        result = result * 59 + ($dbSheet == null ? 43 : $dbSheet.hashCode());
        XSSFSheet $dbDataSheet = this.getDbDataSheet();
        result = result * 59 + ($dbDataSheet == null ? 43 : $dbDataSheet.hashCode());
        ReportData $reportData = this.getReportData();
        result = result * 59 + ($reportData == null ? 43 : $reportData.hashCode());
        return result;
    }

    public String toString() {
        return "DBComponent(dbSheet=" + this.getDbSheet() + ", dbDataSheet=" + this.getDbDataSheet() + ", reportData=" + this.getReportData() + ")";
    }

    public static abstract class DBComponentBuilder<C extends DBComponent, B extends DBComponentBuilder<C, B>> {
        private XSSFSheet dbSheet;
        private XSSFSheet dbDataSheet;
        private ReportData reportData;

        protected abstract B self();

        public abstract C build();

        public B dbSheet(XSSFSheet dbSheet) {
            this.dbSheet = dbSheet;
            return this.self();
        }

        public B dbDataSheet(XSSFSheet dbDataSheet) {
            this.dbDataSheet = dbDataSheet;
            return this.self();
        }

        public B reportData(ReportData reportData) {
            this.reportData = reportData;
            return this.self();
        }

        public String toString() {
            return "DBComponent.DBComponentBuilder(dbSheet=" + this.dbSheet + ", dbDataSheet=" + this.dbDataSheet + ", reportData=" + this.reportData + ")";
        }
    }
}

