/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.dashboard.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.TriConsumer;
import org.apache.poi.ss.util.CellReference;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.dashboard.components.DBComponent;
import tech.grasshopper.excel.report.table.FeatureScenarioFailSkipTable;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.pojo.Status;

public class FeatureScenarioFailSkipDBComponent
extends DBComponent {
    private int featureBarChartIndex;
    private int scenarioBarChartIndex;
    private String failSkipTableStartCell;

    @Override
    public void createComponent() {
        List<SheetData.FeatureData> failSkipFeatures = this.reportData.getFeatureData().stream().filter(f -> f.getStatus() == Status.FAILED || f.getStatus() == Status.SKIPPED).collect(Collectors.toList());
        this.updateFeatureFailSkipTableData(failSkipFeatures);
        this.refreshFeatureFailSkipChartPlot(failSkipFeatures);
        List<SheetData.ScenarioData> failSkipScenarios = this.reportData.getScenarioData().stream().filter(f -> f.getStatus() == Status.FAILED || f.getStatus() == Status.SKIPPED).collect(Collectors.toList());
        this.updateScenarioFailSkipTableData(failSkipScenarios);
        this.refreshScenarioFailSkipChartPlot(failSkipScenarios);
        this.updateDBScenarioFeatureFailSkipTableData();
    }

    private void updateFeatureFailSkipTableData(List<SheetData.FeatureData> failSkipFeatures) {
        SimpleTableOperations<SheetData.FeatureData> dbDataTableOperations = SimpleTableOperations.builder().sheet(this.dbDataSheet).build();
        Function<SheetData.FeatureData, List> rowValueTransformer = f -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = f.getScenarioCounts();
            row.add(f.getName());
            row.add(f.getStatus().toString());
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            return row;
        };
        ArrayList<TriConsumer<CellOperations, CellReference, String>> printFunctions = new ArrayList<TriConsumer<CellOperations, CellReference, String>>();
        printFunctions.add(CellOperations.printString);
        printFunctions.add(CellOperations.printString);
        printFunctions.add(CellOperations.printLong);
        printFunctions.add(CellOperations.printLong);
        printFunctions.add(CellOperations.printLong);
        dbDataTableOperations.writeTableValues("H20", failSkipFeatures, rowValueTransformer, printFunctions);
    }

    private void refreshFeatureFailSkipChartPlot(List<SheetData.FeatureData> failSkipFeatures) {
        ChartOperations dbChartOperations = ChartOperations.builder().dataSheet(this.dbDataSheet).chartSheet(this.dbSheet).build();
        int rows = failSkipFeatures.size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("H20", rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("J20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("L20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("K20", rows));
        dbChartOperations.updateBarChartPlot(this.featureBarChartIndex, categoryRange, valueRanges);
    }

    private void updateScenarioFailSkipTableData(List<SheetData.ScenarioData> failSkipScenarios) {
        SimpleTableOperations<SheetData.ScenarioData> dbDataTableOperations = SimpleTableOperations.builder().sheet(this.dbDataSheet).build();
        Function<SheetData.ScenarioData, List> rowValueTransformer = s -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = s.getStepCounts();
            row.add(s.getName());
            row.add(s.getStatus().toString());
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            return row;
        };
        ArrayList<TriConsumer<CellOperations, CellReference, String>> printFunctions = new ArrayList<TriConsumer<CellOperations, CellReference, String>>();
        printFunctions.add(CellOperations.printString);
        printFunctions.add(CellOperations.printString);
        printFunctions.add(CellOperations.printLong);
        printFunctions.add(CellOperations.printLong);
        printFunctions.add(CellOperations.printLong);
        dbDataTableOperations.writeTableValues("P20", failSkipScenarios, rowValueTransformer, printFunctions);
    }

    private void refreshScenarioFailSkipChartPlot(List<SheetData.ScenarioData> failSkipScenarios) {
        ChartOperations dbChartOperations = ChartOperations.builder().dataSheet(this.dbDataSheet).chartSheet(this.dbSheet).build();
        int rows = failSkipScenarios.size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("P20", rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("R20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("T20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("S20", rows));
        dbChartOperations.updateBarChartPlot(this.scenarioBarChartIndex, categoryRange, valueRanges);
    }

    private void updateDBScenarioFeatureFailSkipTableData() {
        FeatureScenarioFailSkipTable.builder().failSkipFeatureAndScenarioData(this.reportData.getFailSkipFeatureAndScenarioData()).sheet(this.dbSheet).startCell(this.failSkipTableStartCell).build().writeTableValues();
    }

    protected FeatureScenarioFailSkipDBComponent(FeatureScenarioFailSkipDBComponentBuilder<?, ?> b) {
        super(b);
        this.featureBarChartIndex = ((FeatureScenarioFailSkipDBComponentBuilder)b).featureBarChartIndex;
        this.scenarioBarChartIndex = ((FeatureScenarioFailSkipDBComponentBuilder)b).scenarioBarChartIndex;
        this.failSkipTableStartCell = ((FeatureScenarioFailSkipDBComponentBuilder)b).failSkipTableStartCell;
    }

    public static FeatureScenarioFailSkipDBComponentBuilder<?, ?> builder() {
        return new FeatureScenarioFailSkipDBComponentBuilderImpl();
    }

    private static final class FeatureScenarioFailSkipDBComponentBuilderImpl
    extends FeatureScenarioFailSkipDBComponentBuilder<FeatureScenarioFailSkipDBComponent, FeatureScenarioFailSkipDBComponentBuilderImpl> {
        private FeatureScenarioFailSkipDBComponentBuilderImpl() {
        }

        @Override
        protected FeatureScenarioFailSkipDBComponentBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureScenarioFailSkipDBComponent build() {
            return new FeatureScenarioFailSkipDBComponent(this);
        }
    }

    public static abstract class FeatureScenarioFailSkipDBComponentBuilder<C extends FeatureScenarioFailSkipDBComponent, B extends FeatureScenarioFailSkipDBComponentBuilder<C, B>>
    extends DBComponent.DBComponentBuilder<C, B> {
        private int featureBarChartIndex;
        private int scenarioBarChartIndex;
        private String failSkipTableStartCell;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B featureBarChartIndex(int featureBarChartIndex) {
            this.featureBarChartIndex = featureBarChartIndex;
            return (B)this.self();
        }

        public B scenarioBarChartIndex(int scenarioBarChartIndex) {
            this.scenarioBarChartIndex = scenarioBarChartIndex;
            return (B)this.self();
        }

        public B failSkipTableStartCell(String failSkipTableStartCell) {
            this.failSkipTableStartCell = failSkipTableStartCell;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureScenarioFailSkipDBComponent.FeatureScenarioFailSkipDBComponentBuilder(super=" + super.toString() + ", featureBarChartIndex=" + this.featureBarChartIndex + ", scenarioBarChartIndex=" + this.scenarioBarChartIndex + ", failSkipTableStartCell=" + this.failSkipTableStartCell + ")";
        }
    }
}

