/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.dashboard.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.util.TriConsumer;
import org.apache.poi.ss.util.CellReference;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.dashboard.components.DBComponent;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.excel.report.table.TagFeatureScenarioTable;
import tech.grasshopper.extent.data.SheetData;

public class TagFailSkipDBComponent
extends DBComponent {
    private int tagBarChartIndex;
    private String failSkipTableStartCell;

    @Override
    public void createComponent() {
        this.updateTagTableData();
        this.refreshTagChartPlot();
        this.updateDBScenarioFeatureFailSkipTagTableData();
    }

    private void updateTagTableData() {
        SimpleTableOperations<SheetData.TagCountData> dbDataTableOperations = SimpleTableOperations.builder().sheet(this.dbDataSheet).build();
        Function<SheetData.TagCountData, List> rowValueTransformer = t -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = t.getScenarioCounts();
            row.add(t.getName());
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            return row;
        };
        ArrayList<TriConsumer<CellOperations, CellReference, String>> printFunctions = new ArrayList<TriConsumer<CellOperations, CellReference, String>>();
        printFunctions.add(CellOperations.printString);
        printFunctions.add(CellOperations.printLong);
        printFunctions.add(CellOperations.printLong);
        printFunctions.add(CellOperations.printLong);
        dbDataTableOperations.writeTableValues("A20", this.reportData.getFailSkipTagCountData(), rowValueTransformer, printFunctions);
    }

    private void refreshTagChartPlot() {
        ChartOperations dbChartOperations = ChartOperations.builder().dataSheet(this.dbDataSheet).chartSheet(this.dbSheet).build();
        int rows = this.reportData.getFailSkipTagCountData().size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("A20", rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("B20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("D20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("C20", rows));
        dbChartOperations.updateBarChartPlot(this.tagBarChartIndex, categoryRange, valueRanges);
    }

    private void updateDBScenarioFeatureFailSkipTagTableData() {
        TagFeatureScenarioTable.builder().featureAndScenarioTagData(this.reportData.getFailSkipFeatureAndScenarioTagData()).sheet(this.dbSheet).startCell(this.failSkipTableStartCell).columnCellCount(new int[]{1, 3, 1, 1}).groupRows(true).build().writeTableValues();
    }

    protected TagFailSkipDBComponent(TagFailSkipDBComponentBuilder<?, ?> b) {
        super(b);
        this.tagBarChartIndex = ((TagFailSkipDBComponentBuilder)b).tagBarChartIndex;
        this.failSkipTableStartCell = ((TagFailSkipDBComponentBuilder)b).failSkipTableStartCell;
    }

    public static TagFailSkipDBComponentBuilder<?, ?> builder() {
        return new TagFailSkipDBComponentBuilderImpl();
    }

    private static final class TagFailSkipDBComponentBuilderImpl
    extends TagFailSkipDBComponentBuilder<TagFailSkipDBComponent, TagFailSkipDBComponentBuilderImpl> {
        private TagFailSkipDBComponentBuilderImpl() {
        }

        @Override
        protected TagFailSkipDBComponentBuilderImpl self() {
            return this;
        }

        @Override
        public TagFailSkipDBComponent build() {
            return new TagFailSkipDBComponent(this);
        }
    }

    public static abstract class TagFailSkipDBComponentBuilder<C extends TagFailSkipDBComponent, B extends TagFailSkipDBComponentBuilder<C, B>>
    extends DBComponent.DBComponentBuilder<C, B> {
        private int tagBarChartIndex;
        private String failSkipTableStartCell;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tagBarChartIndex(int tagBarChartIndex) {
            this.tagBarChartIndex = tagBarChartIndex;
            return (B)this.self();
        }

        public B failSkipTableStartCell(String failSkipTableStartCell) {
            this.failSkipTableStartCell = failSkipTableStartCell;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TagFailSkipDBComponent.TagFailSkipDBComponentBuilder(super=" + super.toString() + ", tagBarChartIndex=" + this.tagBarChartIndex + ", failSkipTableStartCell=" + this.failSkipTableStartCell + ")";
        }
    }
}

