/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class FeatureScenarioFailSkipTable {
    private XSSFSheet sheet;
    private String startCell;
    private List<Feature> failSkipFeatureAndScenarioData;
    private final int[] columnCellCount = new int[]{2, 1, 2, 1};

    public void writeTableValues() {
        CellOperations cellOperations = CellOperations.builder().sheet(this.sheet).build();
        CellReference cellRef = new CellReference(this.startCell);
        int startRow = cellRef.getRow();
        int startCol = cellRef.getCol();
        int rowCount = (int)this.failSkipFeatureAndScenarioData.stream().mapToLong(f -> f.getTotalScenarios()).sum();
        cellOperations.createCellsWithStyleInRange(startRow, startRow + rowCount, startCol, startCol + Arrays.stream(this.columnCellCount).sum());
        int currentRow = startRow;
        for (Feature feature : this.failSkipFeatureAndScenarioData) {
            int currentCol = startCol;
            cellOperations.mergeRows(currentRow, (int)feature.getTotalScenarios(), currentCol, this.columnCellCount[0]);
            cellOperations.writeStringValueWithStatusColor(new CellReference(currentRow, currentCol), feature.getName(), feature.getStatus());
            cellOperations.mergeRows(currentRow, (int)feature.getTotalScenarios(), currentCol += this.columnCellCount[0], this.columnCellCount[1]);
            cellOperations.writeStatus(new CellReference(currentRow, currentCol), feature.getStatus());
            currentCol += this.columnCellCount[1];
            for (Scenario scenario : feature.getScenarios()) {
                cellOperations.mergeRows(currentRow, 1, currentCol, this.columnCellCount[2]);
                cellOperations.writeStringValueWithStatusColor(new CellReference(currentRow, currentCol), scenario.getName(), scenario.getStatus());
                cellOperations.mergeRows(currentRow, 1, currentCol += this.columnCellCount[2], this.columnCellCount[3]);
                cellOperations.writeStatus(new CellReference(currentRow, currentCol), scenario.getStatus());
                currentCol -= this.columnCellCount[2];
                ++currentRow;
            }
        }
        this.sheet.groupRow(startRow, startRow + rowCount - 1);
        this.sheet.setRowGroupCollapsed(startRow, true);
    }

    FeatureScenarioFailSkipTable(XSSFSheet sheet, String startCell, List<Feature> failSkipFeatureAndScenarioData) {
        this.sheet = sheet;
        this.startCell = startCell;
        this.failSkipFeatureAndScenarioData = failSkipFeatureAndScenarioData;
    }

    public static FeatureScenarioFailSkipTableBuilder builder() {
        return new FeatureScenarioFailSkipTableBuilder();
    }

    public static class FeatureScenarioFailSkipTableBuilder {
        private XSSFSheet sheet;
        private String startCell;
        private List<Feature> failSkipFeatureAndScenarioData;

        FeatureScenarioFailSkipTableBuilder() {
        }

        public FeatureScenarioFailSkipTableBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public FeatureScenarioFailSkipTableBuilder startCell(String startCell) {
            this.startCell = startCell;
            return this;
        }

        public FeatureScenarioFailSkipTableBuilder failSkipFeatureAndScenarioData(List<Feature> failSkipFeatureAndScenarioData) {
            this.failSkipFeatureAndScenarioData = failSkipFeatureAndScenarioData;
            return this;
        }

        public FeatureScenarioFailSkipTable build() {
            return new FeatureScenarioFailSkipTable(this.sheet, this.startCell, this.failSkipFeatureAndScenarioData);
        }

        public String toString() {
            return "FeatureScenarioFailSkipTable.FeatureScenarioFailSkipTableBuilder(sheet=" + this.sheet + ", startCell=" + this.startCell + ", failSkipFeatureAndScenarioData=" + this.failSkipFeatureAndScenarioData + ")";
        }
    }
}

