/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.util.TriConsumer;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;

public class SimpleTableOperations<T> {
    private XSSFSheet sheet;

    public void writeTableValues(String startCell, List<T> tableData, Function<T, List<String>> rowValueTransformer, List<TriConsumer<CellOperations, CellReference, String>> printFunctions) {
        CellReference cellRef = new CellReference(startCell);
        int startRow = cellRef.getRow();
        int endRow = startRow + tableData.size();
        short startColumn = cellRef.getCol();
        int endColumn = startColumn + printFunctions.size();
        CellOperations dbDataCellOperations = CellOperations.builder().sheet(this.sheet).build();
        dbDataCellOperations.createCellsWithStyleInRange(startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i < endRow; ++i) {
            List<String> rowValue = rowValueTransformer.apply(tableData.get(i - startRow));
            int startCol = cellRef.getCol();
            for (int j = 0; j < rowValue.size(); ++j) {
                printFunctions.get(j).accept((Object)dbDataCellOperations, (Object)new CellReference(i, startCol), (Object)rowValue.get(j));
                ++startCol;
            }
        }
    }

    SimpleTableOperations(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public static <T> SimpleTableOperationsBuilder<T> builder() {
        return new SimpleTableOperationsBuilder();
    }

    public static class SimpleTableOperationsBuilder<T> {
        private XSSFSheet sheet;

        SimpleTableOperationsBuilder() {
        }

        public SimpleTableOperationsBuilder<T> sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public SimpleTableOperations<T> build() {
            return new SimpleTableOperations(this.sheet);
        }

        public String toString() {
            return "SimpleTableOperations.SimpleTableOperationsBuilder(sheet=" + this.sheet + ")";
        }
    }
}

