/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.excel.report.util.DateUtil;
import tech.grasshopper.extent.data.pojo.BaseEntity;
import tech.grasshopper.extent.data.pojo.Executable;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Hook;
import tech.grasshopper.extent.data.pojo.NonExecutable;
import tech.grasshopper.extent.data.pojo.Scenario;
import tech.grasshopper.extent.data.pojo.Status;
import tech.grasshopper.extent.data.pojo.Step;

public class ReportDataHeirarchy {
    private Report report;

    public List<Feature> createFeatureHeirarchy() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Test featureTest : this.report.getTestList()) {
            ArrayList<String> featureTags = new ArrayList<String>();
            featureTest.getCategorySet().stream().forEach(c -> featureTags.add(c.getName()));
            ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
            NonExecutable feature = ((Feature.FeatureBuilder)((Feature.FeatureBuilder)((BaseEntity.BaseEntityBuilder)((Feature.FeatureBuilder)((Feature.FeatureBuilder)((Feature.FeatureBuilder)Feature.builder().name(featureTest.getName())).status(this.convertStatus(featureTest.getStatus()))).tags(featureTags)).scenarios(scenarios)).startTime(DateUtil.convertToLocalDateTimeFromDate(featureTest.getStartTime()))).endTime(DateUtil.convertToLocalDateTimeFromDate(featureTest.getEndTime()))).build();
            features.add((Feature)feature);
            for (Test scenarioTest : featureTest.getChildren()) {
                if (scenarioTest.getBddType() == ScenarioOutline.class) {
                    for (Test soScenarioTest : scenarioTest.getChildren()) {
                        this.createScenarioHookSteps(soScenarioTest, scenarios);
                    }
                    continue;
                }
                this.createScenarioHookSteps(scenarioTest, scenarios);
            }
        }
        return features;
    }

    private void createScenarioHookSteps(Test scenarioTest, List<Scenario> scenarios) {
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<Hook> beforeHook = new ArrayList<Hook>();
        ArrayList<Hook> afterHook = new ArrayList<Hook>();
        ArrayList scenarioTags = new ArrayList();
        scenarioTest.getCategorySet().stream().forEach(c -> scenarioTags.add(c.getName()));
        NonExecutable scenario = ((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)((BaseEntity.BaseEntityBuilder)((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)Scenario.builder().name(scenarioTest.getName())).status(this.convertStatus(scenarioTest.getStatus()))).tags((List)scenarioTags)).steps(steps)).before(beforeHook)).after(afterHook)).startTime(DateUtil.convertToLocalDateTimeFromDate(scenarioTest.getStartTime()))).endTime(DateUtil.convertToLocalDateTimeFromDate(scenarioTest.getEndTime()))).build();
        scenarios.add((Scenario)scenario);
        Executable step = null;
        LoopObject loopObject = LoopObject.INITIAL;
        for (Test stepTest : scenarioTest.getChildren()) {
            if (stepTest.getBddType() == Asterisk.class && this.isValidHook(stepTest)) {
                Hook.HookType type = Hook.HookType.valueOf(stepTest.getDescription().toUpperCase());
                switch (type) {
                    case BEFORE: {
                        this.addHookData(beforeHook, stepTest);
                        break;
                    }
                    case AFTER: {
                        this.addHookData(afterHook, stepTest);
                        break;
                    }
                    case BEFORE_STEP: {
                        if (loopObject == LoopObject.INITIAL || loopObject == LoopObject.STEP || loopObject == LoopObject.AFTER_STEP) {
                            step = ((Step.StepBuilder)Step.builder().executableType(Executable.ExecutableType.STEP)).build();
                        }
                        ((Step)step).addBeforeStepHook(this.createHook(stepTest));
                        loopObject = LoopObject.BEFORE_STEP;
                        break;
                    }
                    case AFTER_STEP: {
                        ((Step)step).addAfterStepHook(this.createHook(stepTest));
                        loopObject = LoopObject.AFTER_STEP;
                    }
                }
                continue;
            }
            if (loopObject == LoopObject.INITIAL || loopObject == LoopObject.STEP || loopObject == LoopObject.AFTER_STEP) {
                step = ((Step.StepBuilder)Step.builder().executableType(Executable.ExecutableType.STEP)).build();
            }
            this.addStepData((Step)step, stepTest);
            steps.add((Step)step);
            loopObject = LoopObject.STEP;
        }
    }

    private void addStepData(Step step, Test stepTest) {
        step.setName(stepTest.getName());
        step.setStatus(this.convertStatus(stepTest.getStatus()));
        step.setKeyword(stepTest.getBddType().getSimpleName());
        step.setErrorMessage(this.getStackTrace(stepTest));
        step.setStartTime(DateUtil.convertToLocalDateTimeFromDate(stepTest.getStartTime()));
        step.setEndTime(DateUtil.convertToLocalDateTimeFromDate(stepTest.getEndTime()));
    }

    private void addHookData(List<Hook> hooks, Test hookTest) {
        hooks.add(this.createHook(hookTest));
    }

    private Hook createHook(Test hookTest) {
        return ((Hook.HookBuilder)((Hook.HookBuilder)((Hook.HookBuilder)((Hook.HookBuilder)((Executable.ExecutableBuilder)((Hook.HookBuilder)((Hook.HookBuilder)Hook.builder().executableType(Executable.ExecutableType.HOOK)).location(hookTest.getName())).hookType(Hook.HookType.valueOf(hookTest.getDescription()))).status(this.convertStatus(hookTest.getStatus()))).errorMessage(this.getStackTrace(hookTest))).startTime(DateUtil.convertToLocalDateTimeFromDate(hookTest.getStartTime()))).endTime(DateUtil.convertToLocalDateTimeFromDate(hookTest.getEndTime()))).build();
    }

    private boolean isValidHook(Test test) {
        return Arrays.stream(Hook.HookType.values()).anyMatch(h -> h.name().equals(test.getDescription().toUpperCase()));
    }

    private Status convertStatus(com.aventstack.extentreports.Status extentStatus) {
        Status status = Status.SKIPPED;
        if (extentStatus == com.aventstack.extentreports.Status.PASS) {
            status = Status.PASSED;
        } else if (extentStatus == com.aventstack.extentreports.Status.FAIL) {
            status = Status.FAILED;
        }
        return status;
    }

    public String getStackTrace(Test test) {
        List failAndSkipLogs = test.getLogs().stream().filter(l -> l.getStatus() == com.aventstack.extentreports.Status.FAIL || l.getStatus() == com.aventstack.extentreports.Status.SKIP).collect(Collectors.toList());
        for (Log log : failAndSkipLogs) {
            if (log.getException() == null) continue;
            return log.getException().getStackTrace();
        }
        return "";
    }

    ReportDataHeirarchy(Report report) {
        this.report = report;
    }

    public static ReportDataHeirarchyBuilder builder() {
        return new ReportDataHeirarchyBuilder();
    }

    public static class ReportDataHeirarchyBuilder {
        private Report report;

        ReportDataHeirarchyBuilder() {
        }

        public ReportDataHeirarchyBuilder report(Report report) {
            this.report = report;
            return this;
        }

        public ReportDataHeirarchy build() {
            return new ReportDataHeirarchy(this.report);
        }

        public String toString() {
            return "ReportDataHeirarchy.ReportDataHeirarchyBuilder(report=" + this.report + ")";
        }
    }

    private static enum LoopObject {
        INITIAL,
        BEFORE_STEP,
        STEP,
        AFTER_STEP;

    }
}

