/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.NonExecutable;
import tech.grasshopper.extent.data.pojo.Scenario;
import tech.grasshopper.extent.data.pojo.Status;

public class TagDataPopulator {
    private List<Feature> features;

    public void populateTagCountData(List<SheetData.TagCountData> tagData) {
        this.populateTagCountData(tagData, this.features);
    }

    public void populateFailAndSkipScenariosTagCountData(List<SheetData.TagCountData> failSkipTagData) {
        List<Feature> statusFailAndSkippedFeatures = this.features.stream().filter(f -> f.getStatus() != Status.PASSED).collect(Collectors.toList());
        this.populateTagCountData(failSkipTagData, statusFailAndSkippedFeatures);
        this.removeTagsWithOnlyPassedScenarios(failSkipTagData);
    }

    private void populateTagCountData(List<SheetData.TagCountData> tagData, List<Feature> statusFilteredFeatures) {
        HashMap<String, SheetData.TagCountData> tagDatas = new HashMap<String, SheetData.TagCountData>();
        for (Feature feature : statusFilteredFeatures) {
            for (Scenario scenario : feature.getScenarios()) {
                List<String> tags = scenario.getTags();
                for (String tag : tags) {
                    SheetData.TagCountData td = tagDatas.computeIfAbsent(tag, k -> SheetData.TagCountData.builder().name(tag).scenarioCounts(SheetData.CountData.builder().build()).build());
                    if (!tagData.stream().anyMatch(t -> td.getName().equals(t.getName()))) {
                        tagData.add(td);
                    }
                    SheetData.CountData scenarioCounts = td.getScenarioCounts();
                    scenarioCounts.setTotal(scenarioCounts.getTotal() + 1L);
                    if (scenario.getStatus() == Status.PASSED) {
                        scenarioCounts.setPassed(scenarioCounts.getPassed() + 1L);
                        continue;
                    }
                    if (scenario.getStatus() == Status.FAILED) {
                        scenarioCounts.setFailed(scenarioCounts.getFailed() + 1L);
                        continue;
                    }
                    if (scenario.getStatus() != Status.SKIPPED) continue;
                    scenarioCounts.setSkipped(scenarioCounts.getSkipped() + 1L);
                }
            }
        }
    }

    private void removeTagsWithOnlyPassedScenarios(List<SheetData.TagCountData> tagData) {
        tagData.removeIf(td -> td.getScenarioCounts().getPassed() == td.getScenarioCounts().getTotal());
    }

    public void populateFailSkipFeatureScenarioData(Map<String, List<Feature>> data) {
        for (Feature feature : this.features) {
            if (feature.getStatus() == Status.PASSED) continue;
            for (Scenario scenario : feature.getScenarios()) {
                if (scenario.getStatus() == Status.PASSED) continue;
                this.populateTagFeatureScenarioData(data, feature, scenario);
            }
        }
    }

    public void populateFeatureScenarioData(Map<String, List<Feature>> data) {
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                this.populateTagFeatureScenarioData(data, feature, scenario);
            }
        }
    }

    private void populateTagFeatureScenarioData(Map<String, List<Feature>> data, Feature feature, Scenario scenario) {
        for (String tag : scenario.getTags()) {
            List feats = data.computeIfAbsent(tag, f -> new ArrayList());
            Feature feat = feats.stream().filter(f -> f.getName().equals(feature.getName())).findAny().orElseGet(() -> {
                NonExecutable f = ((Feature.FeatureBuilder)((Feature.FeatureBuilder)Feature.builder().name(feature.getName())).status(feature.getStatus())).build();
                feats.add(f);
                return f;
            });
            feat.getScenarios().add((Scenario)((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)Scenario.builder().name(scenario.getName())).status(scenario.getStatus())).build());
            feat.setTotalScenarios(feat.getTotalScenarios() + 1L);
        }
    }

    TagDataPopulator(List<Feature> features) {
        this.features = features;
    }

    public static TagDataPopulatorBuilder builder() {
        return new TagDataPopulatorBuilder();
    }

    public static class TagDataPopulatorBuilder {
        private List<Feature> features;

        TagDataPopulatorBuilder() {
        }

        public TagDataPopulatorBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public TagDataPopulator build() {
            return new TagDataPopulator(this.features);
        }

        public String toString() {
            return "TagDataPopulator.TagDataPopulatorBuilder(features=" + this.features + ")";
        }
    }
}

