/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter;

import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.reporter.AbstractFileReporter;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.excel.report.workbook.ReportWorkbook;
import tech.grasshopper.extent.data.ReportData;

public class ExtentExcelCucumberReporter
extends AbstractFileReporter
implements ReportObserver<ReportEntity> {
    private static final Logger logger = Logger.getLogger(ExtentExcelCucumberReporter.class.getName());
    private static final String FILE_NAME = "report.xlsx";
    private Disposable disposable;
    private Report report;

    public ExtentExcelCucumberReporter(String path) {
        super(new File(path));
    }

    protected ExtentExcelCucumberReporter(File f) {
        super(f);
    }

    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
                ExtentExcelCucumberReporter.this.start(d);
            }

            public void onNext(ReportEntity value) {
                ExtentExcelCucumberReporter.this.flush(value);
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private void start(Disposable d) {
        this.disposable = d;
    }

    private void flush(ReportEntity value) {
        try {
            this.report = value.getReport();
            String reportXls = this.getFileNameAsExt(FILE_NAME, new String[]{".xlsx"});
            ReportData reportData = new ReportData();
            reportData.createData(this.report);
            ReportWorkbook.createReport(reportData, reportXls);
        }
        catch (Exception e) {
            this.disposable.dispose();
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }
}

