/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.MediaEntityBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.iharder.Base64;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;
import tech.grasshopper.pojo.Embedded;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.properties.ReportProperties;

@Singleton
public class EmbeddedProcessor {
    private static final AtomicInteger EMBEDDED_INT = new AtomicInteger(0);
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/svg+xml", "svg");
            this.put("video/ogg", "ogg");
        }
    };
    private ReportProperties reportProperties;
    private ExtentReportsCucumberLogger logger;

    @Inject
    public EmbeddedProcessor(ReportProperties reportProperties, ExtentReportsCucumberLogger logger) {
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public void updateExtentTestWithEmbedding(ExtentTest test, List<Embedded> embeddings) {
        for (Embedded embed : embeddings) {
            String name = embed.getName() == null ? "" : embed.getName();
            String filePath = embed.getFilePath();
            if (filePath == null || filePath.isEmpty()) {
                this.logger.warn("Skipping adding embedded file as filepath is empty for step - '" + test.getModel().getName() + "'.");
                return;
            }
            try {
                test.info(name, MediaEntityBuilder.createScreenCaptureFromPath((String)filePath).build());
                test.addScreenCaptureFromPath(filePath);
            }
            catch (Exception e) {
                this.logger.warn("Skipping adding embedded file for step - '" + test.getModel().getName() + "' as error in processing.");
                return;
            }
        }
    }

    public void processFeatures(List<Feature> features) {
        List<Embedded> embeddings = this.collectAllEmbeddings(features);
        this.processEmbeddings(embeddings);
    }

    public void processEmbeddings(List<Embedded> embeddings) {
        for (Embedded embed : embeddings) {
            String mimeType = embed.getMimeType();
            String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
            if (extension != null) {
                Path path = this.createEmbeddedFileStructure(extension);
                try {
                    Files.write(path, Base64.decode((String)embed.getData()), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.logger.warn("Skipping embedded file creation at location - " + path.toString() + ", due to error in creating file.");
                    continue;
                }
                embed.setData("");
                embed.setFilePath(path.toString());
                continue;
            }
            this.logger.warn("Mime type '" + mimeType + "' not supported.");
        }
    }

    private List<Embedded> collectAllEmbeddings(List<Feature> features) {
        ArrayList<Embedded> embeddings = new ArrayList<Embedded>();
        List scenarios = features.stream().flatMap(f -> f.getElements().stream()).collect(Collectors.toList());
        List steps = scenarios.stream().flatMap(s -> s.getSteps().stream()).collect(Collectors.toList());
        embeddings.addAll(scenarios.stream().flatMap(s -> s.getBeforeAfterHooks().stream()).flatMap(h -> h.getEmbeddings().stream()).collect(Collectors.toList()));
        embeddings.addAll(steps.stream().flatMap(s -> s.getEmbeddings().stream()).collect(Collectors.toList()));
        embeddings.addAll(steps.stream().flatMap(s -> s.getBeforeAfterHooks().stream()).flatMap(h -> h.getEmbeddings().stream()).collect(Collectors.toList()));
        return embeddings;
    }

    private Path createEmbeddedFileStructure(String extension) {
        StringBuilder fileName = new StringBuilder("embedded").append(EMBEDDED_INT.incrementAndGet()).append(".").append(extension);
        String embedDirPath = this.reportProperties.getReportScreenshotLocation();
        File dir = new File(embedDirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(embedDirPath + "/" + fileName);
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        if (file.exists()) {
            file.delete();
        }
        return path;
    }
}

