/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.properties;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.ExtentReportsCucumberPlugin;
import tech.grasshopper.exception.ExtentReportsCucumberPluginException;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;

@Singleton
public class ReportProperties {
    private String reportsPropertiesFolder;
    private String reportsPropertiesFileName;
    private ExtentReportsCucumberLogger logger;
    private static final Properties properties = new Properties();
    private static final String DEFAULT_REPORTS_PROPERTIES_FILE = "tech/grasshopper/properties/extent.properties";
    private static final String DEFAULT_PROJECT_REPORTS_PROPERTIES_FILE_NAME = "extent.properties";
    public static final String DEFAULT_REPORTS_PROPERTIES = "extent.reporter.";
    public static final String DEFAULT_REPORTS_PROPERTIES_CLASS = ".class";
    public static final String DEFAULT_REPORTS_PROPERTIES_START = ".start";
    public static final String DEFAULT_REPORTS_PROPERTIES_CONFIG = ".config";
    public static final String DEFAULT_REPORTS_PROPERTIES_OUT = ".out";
    public static final String DEFAULT_REPORTS_SCREENSHOTS_DIRECTORY = "screenshot.dir";
    private static final String DEFAULT_SCREENSHOTS_LOCATION = "test-output/";

    @Inject
    public ReportProperties(ExtentReportsCucumberLogger logger) {
        this.reportsPropertiesFileName = DEFAULT_PROJECT_REPORTS_PROPERTIES_FILE_NAME;
        this.logger = logger;
    }

    ReportProperties(Properties props) {
        properties.putAll((Map<?, ?>)props);
    }

    public void loadPropertyFiles(String folderName, String fileName) {
        if (folderName != null && !folderName.isEmpty()) {
            this.reportsPropertiesFolder = folderName;
        }
        if (fileName != null && !fileName.isEmpty()) {
            this.reportsPropertiesFileName = fileName;
        }
        this.loadDefaultPropertyFile();
        this.loadProjectPropertyFile();
    }

    private void loadDefaultPropertyFile() {
        ClassLoader loader = ExtentReportsCucumberPlugin.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(DEFAULT_REPORTS_PROPERTIES_FILE);
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new ExtentReportsCucumberPluginException("Stopping report generation as default extent report properties file not available at - tech/grasshopper/properties/extent.properties.");
        }
    }

    private void loadProjectPropertyFile() {
        if (this.reportsPropertiesFolder != null) {
            try {
                FileInputStream is = new FileInputStream(this.reportsPropertiesFolder + "/" + this.reportsPropertiesFileName);
                properties.load(is);
            }
            catch (FileNotFoundException e) {
                this.logger.warn("Skipping reading project extent properties as file not found at location - " + this.reportsPropertiesFolder + "/" + this.reportsPropertiesFileName + ".");
            }
            catch (IOException e) {
                this.logger.warn("Skipping reading project extent properties due to parsing error.");
            }
        }
    }

    public Map<String, String> retrieveReportIdToClassNameMappings() {
        HashMap idToName = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            Pattern pattern;
            Matcher matcher;
            String key = String.valueOf(k);
            if (key.endsWith(DEFAULT_REPORTS_PROPERTIES_CLASS) && (matcher = (pattern = Pattern.compile("extent.reporter.([\\w]+).class")).matcher(key)).find()) {
                idToName.put(matcher.group(1), String.valueOf(v));
            }
        }));
        if (idToName.size() == 0) {
            throw new ExtentReportsCucumberPluginException("Skipping reports generation as no report 'class' value available in extent properties file.");
        }
        return new HashMap<String, String>(idToName);
    }

    public String getProperty(String name) {
        return properties.getProperty(name, "").trim();
    }

    public String getReportClassNameProperty(String key) {
        return this.getProperty(DEFAULT_REPORTS_PROPERTIES + key + DEFAULT_REPORTS_PROPERTIES_CLASS);
    }

    public String getReportStartProperty(String key) {
        return this.getProperty(DEFAULT_REPORTS_PROPERTIES + key + DEFAULT_REPORTS_PROPERTIES_START);
    }

    public String getReportConfigProperty(String key) {
        return this.getProperty(DEFAULT_REPORTS_PROPERTIES + key + DEFAULT_REPORTS_PROPERTIES_CONFIG);
    }

    public String getReportOutProperty(String key) {
        return this.getProperty(DEFAULT_REPORTS_PROPERTIES + key + DEFAULT_REPORTS_PROPERTIES_OUT);
    }

    public String getReportScreenshotLocation() {
        String screenshotDirectory = DEFAULT_SCREENSHOTS_LOCATION;
        if (!this.getProperty(DEFAULT_REPORTS_SCREENSHOTS_DIRECTORY).isEmpty()) {
            screenshotDirectory = this.getProperty(DEFAULT_REPORTS_SCREENSHOTS_DIRECTORY);
        }
        return screenshotDirectory;
    }

    public boolean checkReportRequired(String key) {
        return this.getProperty(DEFAULT_REPORTS_PROPERTIES + key + DEFAULT_REPORTS_PROPERTIES_START).equalsIgnoreCase("true");
    }
}

