/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporters;

import com.aventstack.extentreports.reporter.ConfigurableReporter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.exception.ExtentReportsCucumberPluginException;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.reporters.aggregates.ReportAggregateUpdater;

@Singleton
public class ReporterInitializer {
    private Map<String, ConfigurableReporter> reportKeyToInstance = new HashMap<String, ConfigurableReporter>();
    private ReportProperties reportProperties;
    private ExtentReportsCucumberLogger logger;

    @Inject
    public ReporterInitializer(ReportProperties reportProperties, ExtentReportsCucumberLogger logger) {
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public void instantiate() {
        this.reportProperties.retrieveReportIdToClassNameMappings().forEach((k, v) -> {
            if (this.reportProperties.checkReportRequired((String)k)) {
                ConfigurableReporter reportInstance = this.instantiateReporter((String)v, this.reportProperties.getReportOutProperty((String)k));
                if (reportInstance == null) {
                    return;
                }
                this.loadReporterUISettings(reportInstance, this.reportProperties.getReportConfigProperty((String)k));
                this.reportKeyToInstance.put((String)k, reportInstance);
            }
        });
        if (this.reportKeyToInstance.size() == 0) {
            throw new ExtentReportsCucumberPluginException("Skipping reports generation as no report 'start' value set to 'true' in extent properties file.");
        }
    }

    public Map<String, ConfigurableReporter> getReportKeyToInstance() {
        return this.reportKeyToInstance;
    }

    private ConfigurableReporter instantiateReporter(String clsName, String reportOutputFolder) {
        ConfigurableReporter reportInstance = null;
        try {
            Class<?> reportClass = Class.forName(clsName);
            Constructor<?> reportConstructor = reportClass.getConstructor(String.class);
            reportInstance = (ConfigurableReporter)reportConstructor.newInstance(reportOutputFolder);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.warn("Skipping report of class - " + clsName + ", as unable to instantiate reporter class. Check the value in extent properties.");
        }
        catch (ClassCastException e) {
            this.logger.warn("Skipping report of class - " + clsName + ", as unable to cast to 'com.aventstack.extentreports.reporter.ConfigurableReporter' class.");
        }
        catch (Exception e) {
            this.logger.warn("Skipping report of class - " + clsName + " due to following exception - " + e.getMessage() + ".");
        }
        return reportInstance;
    }

    private void loadReporterUISettings(ConfigurableReporter reportInstance, String reportConfigPath) {
        if (!reportConfigPath.isEmpty()) {
            reportInstance.loadXMLConfig(reportConfigPath);
        }
    }

    public ReportAggregateUpdater instantiatReportAggregateUpdater(List<Feature> features) {
        return new ReportAggregateUpdater(features);
    }
}

