/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporters.aggregates;

import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.pojo.Hook;
import tech.grasshopper.pojo.Result;
import tech.grasshopper.pojo.Scenario;
import tech.grasshopper.pojo.Step;

public class DurationCalculator {
    private List<Feature> features;
    private List<Test> extentTestHeirarchy;
    private List<Scenario> scenarios;
    private Date updatedDate;

    public DurationCalculator(List<Feature> features, List<Test> extentTestHeirarchy) {
        this.features = features;
        this.extentTestHeirarchy = extentTestHeirarchy;
        this.scenarios = features.stream().flatMap(f -> f.getElements().stream()).collect(Collectors.toList());
        this.updatedDate = new Date();
    }

    public ReporterDuration calculateReportDuration() {
        ReporterDuration durationData = new ReporterDuration();
        Comparator dateComparator = Date::compareTo;
        durationData.setStartTime((Date)this.features.stream().map(Feature::getStartTime).sorted(dateComparator).collect(Collectors.toList()).get(0));
        durationData.setEndTime((Date)this.features.stream().map(Feature::getEndTime).sorted(dateComparator.reversed()).collect(Collectors.toList()).get(0));
        return durationData;
    }

    public void updateExtentTestTimeData() {
        List featureChildrenTests = this.extentTestHeirarchy.stream().flatMap(e -> e.getNodeContext().getAll().stream()).collect(Collectors.toList());
        ArrayList<Test> scenarioTests = new ArrayList<Test>();
        for (Test test : featureChildrenTests) {
            if (test.getBehaviorDrivenTypeName().equalsIgnoreCase("Scenario Outline")) {
                scenarioTests.addAll(test.getNodeContext().getAll());
                this.updateScenarioOutlineExtentTestStartEndTimes(test);
                continue;
            }
            scenarioTests.add(test);
        }
        this.updateScenarioExtentTestStartEndTimes(scenarioTests);
    }

    protected void updateScenarioOutlineExtentTestStartEndTimes(Test scenarioOutlineExtentTest) {
        List childTestIds = scenarioOutlineExtentTest.getNodeContext().getAll().stream().map(t -> t.getId()).collect(Collectors.toList());
        List childScenarios = this.scenarios.stream().filter(s -> childTestIds.contains(s.getTestId())).collect(Collectors.toList());
        List startTimes = childScenarios.stream().map(s -> s.getStartTime()).collect(Collectors.toList());
        List endTimes = childScenarios.stream().map(s -> s.getEndTime()).collect(Collectors.toList());
        Comparator dateComparator = Date::compareTo;
        Comparator dateComparatorReversed = dateComparator.reversed();
        startTimes.sort(dateComparator);
        endTimes.sort(dateComparatorReversed);
        scenarioOutlineExtentTest.setStartTime((Date)startTimes.get(0));
        scenarioOutlineExtentTest.setEndTime((Date)endTimes.get(0));
    }

    protected void updateScenarioExtentTestStartEndTimes(List<Test> scenarioExtentTests) {
        Map idToScenarioMap = this.scenarios.stream().collect(Collectors.toMap(Scenario::getTestId, Function.identity()));
        scenarioExtentTests.forEach(s -> {
            Scenario matched = (Scenario)idToScenarioMap.get(s.getId());
            s.setStartTime(matched.getStartTime());
            s.setEndTime(matched.getEndTime());
        });
        List<Test> stepAndHooksExtentTests = scenarioExtentTests.stream().flatMap(e -> e.getNodeContext().getAll().stream()).collect(Collectors.toList());
        this.updateStepAndHookExtentTestStartEndTimesAndLogTimestamp(stepAndHooksExtentTests);
    }

    private void updateStepAndHookExtentTestStartEndTimesAndLogTimestamp(List<Test> stepAndHooksExtentTests) {
        Map idToTestMap = stepAndHooksExtentTests.stream().collect(Collectors.toMap(Test::getId, Function.identity()));
        this.scenarios.forEach(s -> {
            this.updatedDate = s.getStartTime();
            this.updateHookExtentTestStartEndTimesAndLogTimestamp(s.getBefore(), idToTestMap);
            for (Step step : s.getSteps()) {
                this.updateHookExtentTestStartEndTimesAndLogTimestamp(step.getBefore(), idToTestMap);
                this.updateStepExtentTestStartEndTimesAndLogTimestamp(step, idToTestMap);
                this.updateHookExtentTestStartEndTimesAndLogTimestamp(step.getAfter(), idToTestMap);
            }
            this.updateHookExtentTestStartEndTimesAndLogTimestamp(s.getAfter(), idToTestMap);
        });
    }

    private void updateHookExtentTestStartEndTimesAndLogTimestamp(List<Hook> hooks, Map<Integer, Test> idToTestMap) {
        for (Hook hook : hooks) {
            Test hookTest = idToTestMap.get(hook.getTestId());
            this.updateTestStartEndTimesAndLogTimestamp(hookTest, hook.getResult());
        }
    }

    private void updateStepExtentTestStartEndTimesAndLogTimestamp(Step step, Map<Integer, Test> idToTestMap) {
        Test stepTest = idToTestMap.get(step.getTestId());
        this.updateTestStartEndTimesAndLogTimestamp(stepTest, step.getResult());
    }

    private void updateTestStartEndTimesAndLogTimestamp(Test test, Result result) {
        test.setStartTime(this.updatedDate);
        Date logTimeStamp = this.updatedDate;
        List stepLogs = test.getLogContext().getAll();
        stepLogs.forEach(l -> l.setTimestamp(logTimeStamp));
        this.updatedDate = Date.from(this.updatedDate.toInstant().plusNanos(result.getDuration()));
        test.setEndTime(this.updatedDate);
    }

    public static class ReporterDuration {
        private Date startTime;
        private Date endTime;

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReporterDuration)) {
                return false;
            }
            ReporterDuration other = (ReporterDuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$startTime = this.getStartTime();
            Date other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReporterDuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            return result;
        }

        public String toString() {
            return "DurationCalculator.ReporterDuration(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }
    }
}

