/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import com.aventstack.extentreports.markuputils.MarkupHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.pojo.Step;
import tech.grasshopper.processor.DataTableProcessor;

@Singleton
public class StepProcessor {
    private DataTableProcessor dataTableProcessor;

    @Inject
    public StepProcessor(DataTableProcessor dataTableProcessor) {
        this.dataTableProcessor = dataTableProcessor;
    }

    public void process(Step step) {
        this.updateDataTableMarkup(step);
        this.updateDocString(step);
    }

    protected void updateDataTableMarkup(Step step) {
        List<List<String>> cells = step.getRows().stream().map(r -> r.getCells()).collect(Collectors.toList());
        if (cells.size() < 1) {
            return;
        }
        step.setDataTableMarkup(this.dataTableProcessor.processTable(cells));
    }

    protected void updateDocString(Step step) {
        if (step.getDocString().getValue() == null || step.getDocString().getValue().isEmpty()) {
            return;
        }
        step.setDocStringMarkup(MarkupHelper.createCodeBlock((String)step.getDocString().getValue()).getMarkup());
    }
}

