/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporters;

import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.exception.ExtentReportsCucumberPluginException;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.reporters.ReporterAdapter;

@Singleton
public class ReporterInitializer {
    private Map<String, ExtentObserver<?>> reportKeyToInstance = new HashMap();
    private ReportProperties reportProperties;
    private ExtentReportsCucumberLogger logger;

    @Inject
    public ReporterInitializer(ReportProperties reportProperties, ExtentReportsCucumberLogger logger) {
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public void instantiate() {
        this.reportProperties.retrieveReportIdToClassNameMappings().forEach((k, v) -> {
            if (this.reportProperties.checkReportRequired((String)k)) {
                ExtentObserver<?> reportInstance = this.instantiateReporter((String)k, (String)v);
                if (reportInstance == null) {
                    return;
                }
                this.loadReporterUISettings(reportInstance, this.reportProperties.getReportConfigProperty((String)k));
                this.reportKeyToInstance.put((String)k, reportInstance);
            }
        });
        if (this.reportKeyToInstance.size() == 0) {
            throw new ExtentReportsCucumberPluginException("Skipping reports generation as no report 'start' value set to 'true' in extent properties file.");
        }
    }

    public Map<String, ExtentObserver<?>> getReportKeyToInstance() {
        return this.reportKeyToInstance;
    }

    private ExtentObserver<?> instantiateReporter(String key, String clsName) {
        ExtentObserver<?> reportInstance = null;
        try {
            Class<?> reportClass = Class.forName(clsName);
            Constructor<?> reportConstructor = reportClass.getConstructor(String.class, ReportProperties.class);
            ReporterAdapter reportAdapter = (ReporterAdapter)reportConstructor.newInstance(key, this.reportProperties);
            reportInstance = reportAdapter.createReporter();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.warn("Skipping report of class - " + clsName + ", as unable to instantiate reporter class. Check the value in extent properties.");
        }
        catch (ClassCastException e) {
            this.logger.warn("Skipping report of class - " + clsName + ", as unable to cast to 'com.aventstack.extentreports.observer.ExtentObserver' class.");
        }
        catch (Exception e) {
            this.logger.warn("Skipping report of class - " + clsName + " due to following exception - " + e.getMessage() + ".");
        }
        return reportInstance;
    }

    private void loadReporterUISettings(ExtentObserver<?> reportInstance, String reportConfigPath) {
        if (!reportConfigPath.isEmpty()) {
            try {
                ((ReporterConfigurable)reportInstance).loadXMLConfig(reportConfigPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

