/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.test.heirarchy;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.pojo.Scenario;
import tech.grasshopper.pojo.Step;
import tech.grasshopper.processor.EmbeddedProcessor;
import tech.grasshopper.processor.FeatureProcessor;
import tech.grasshopper.processor.ScenarioProcessor;
import tech.grasshopper.processor.StepProcessor;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.test.heirarchy.ExtentTestHeirarchy;

@Singleton
public class DefaultExtentTestHeirarchy
extends ExtentTestHeirarchy {
    @Inject
    public DefaultExtentTestHeirarchy(FeatureProcessor featureProcessor, ScenarioProcessor scenarioProcessor, StepProcessor stepProcessor, EmbeddedProcessor embeddedProcessor, ReportProperties reportProperties) {
        super(featureProcessor, scenarioProcessor, stepProcessor, embeddedProcessor, reportProperties);
    }

    DefaultExtentTestHeirarchy(FeatureProcessor featureProcessor, ScenarioProcessor scenarioProcessor, StepProcessor stepProcessor, EmbeddedProcessor embeddedProcessor, ExtentReports extent, ReportProperties reportProperties) {
        super(featureProcessor, scenarioProcessor, stepProcessor, embeddedProcessor, extent, reportProperties);
    }

    @Override
    public void createTestHeirarchy(List<Feature> features, ExtentReports extent) {
        this.features = features;
        this.extent = extent;
        features.forEach(feature -> {
            this.featureProcessor.process((Feature)feature);
            ExtentTest featureTest = this.createFeatureExtentTest((Feature)feature);
            feature.getElements().forEach(scenario -> {
                this.scenarioProcessor.process((Scenario)scenario, (Feature)feature);
                ExtentTest scenarioTest = this.createScenarioExtentNode(featureTest, (Scenario)scenario);
                this.createBeforeHookExtentNodes(scenarioTest, (Scenario)scenario);
                scenario.getSteps().forEach(step -> {
                    this.stepProcessor.process((Step)step);
                    this.createBeforeStepHookExtentNodes(scenarioTest, (Step)step);
                    this.createStepExtentNode(scenarioTest, (Step)step);
                    this.createAfterStepHookExtentNodes(scenarioTest, (Step)step);
                });
                this.createAfterHookExtentNodes(scenarioTest, (Scenario)scenario);
            });
        });
    }
}

