/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.test;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.observer.ExtentObserver;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.reporters.ReporterInitializer;
import tech.grasshopper.test.heirarchy.DefaultExtentTestHeirarchy;

@Singleton
public class ExtentTestManager {
    private ExtentReports extent = new ExtentReports();
    private ReporterInitializer reportInitializer;
    private DefaultExtentTestHeirarchy testHeirarchy;

    @Inject
    public ExtentTestManager(ReporterInitializer reportInitializer, DefaultExtentTestHeirarchy testHeirarchy) {
        this.reportInitializer = reportInitializer;
        this.testHeirarchy = testHeirarchy;
    }

    public void initialize(List<Feature> features) {
        Map<String, ExtentObserver<?>> reporters = this.reportInitializer.getReportKeyToInstance();
        this.extent.setReportUsesManualConfiguration(true);
        this.testHeirarchy.createTestHeirarchy(features, this.extent);
        for (String key : reporters.keySet()) {
            ExtentObserver<?> reporter = reporters.get(key);
            this.extent.attachReporter(new ExtentObserver[]{reporter});
        }
    }

    public void flushToReporters() {
        this.extent.flush();
    }
}

