/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.test.heirarchy;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.Feature;
import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import tech.grasshopper.pojo.Embedded;
import tech.grasshopper.pojo.Hook;
import tech.grasshopper.pojo.Result;
import tech.grasshopper.pojo.Scenario;
import tech.grasshopper.pojo.Step;
import tech.grasshopper.processor.EmbeddedProcessor;
import tech.grasshopper.processor.FeatureProcessor;
import tech.grasshopper.processor.ScenarioProcessor;
import tech.grasshopper.processor.StepProcessor;
import tech.grasshopper.properties.ReportProperties;

public abstract class ExtentTestHeirarchy {
    protected List<tech.grasshopper.pojo.Feature> features;
    protected ExtentReports extent;
    protected Map<String, ExtentTest> uriFeatureTestMap = new HashMap<String, ExtentTest>();
    protected Map<String, ExtentTest> uriLinesScenarioOutlineTestMap = new HashMap<String, ExtentTest>();
    protected FeatureProcessor featureProcessor;
    protected ScenarioProcessor scenarioProcessor;
    protected StepProcessor stepProcessor;
    protected EmbeddedProcessor embeddedProcessor;
    private ReportProperties reportProperties;

    @Inject
    protected ExtentTestHeirarchy(FeatureProcessor featureProcessor, ScenarioProcessor scenarioProcessor, StepProcessor stepProcessor, EmbeddedProcessor embeddedProcessor, ReportProperties reportProperties) {
        this.featureProcessor = featureProcessor;
        this.scenarioProcessor = scenarioProcessor;
        this.stepProcessor = stepProcessor;
        this.embeddedProcessor = embeddedProcessor;
        this.reportProperties = reportProperties;
    }

    protected ExtentTestHeirarchy(FeatureProcessor featureProcessor, ScenarioProcessor scenarioProcessor, StepProcessor stepProcessor, EmbeddedProcessor embeddedProcessor, ExtentReports extent, ReportProperties reportProperties) {
        this(featureProcessor, scenarioProcessor, stepProcessor, embeddedProcessor, reportProperties);
        this.extent = extent;
    }

    public abstract void createTestHeirarchy(List<tech.grasshopper.pojo.Feature> var1, ExtentReports var2);

    public ExtentTest createFeatureExtentTest(tech.grasshopper.pojo.Feature feature) {
        String uri = feature.getUri();
        if (this.uriFeatureTestMap.containsKey(uri)) {
            return this.uriFeatureTestMap.get(uri);
        }
        ExtentTest featureExtentTest = this.extent.createTest(Feature.class, feature.getName(), feature.getDescription());
        this.uriFeatureTestMap.put(uri, featureExtentTest);
        feature.getTags().forEach(t -> featureExtentTest.assignCategory(new String[]{t.getName()}));
        Test test = featureExtentTest.getModel();
        test.setStartTime(feature.getStartTime());
        test.setEndTime(feature.getEndTime());
        feature.setTestId(test.getId());
        return featureExtentTest;
    }

    public ExtentTest createScenarioExtentNode(ExtentTest parentExtentTest, Scenario scenario) {
        if (scenario.getKeyword().equalsIgnoreCase("Scenario Outline")) {
            parentExtentTest = this.createScenarioOutlineExtentNode(parentExtentTest, scenario);
        }
        ExtentTest scenarioExtentTest = parentExtentTest.createNode(com.aventstack.extentreports.gherkin.model.Scenario.class, scenario.getName(), scenario.getDescription());
        scenario.getTags().forEach(t -> scenarioExtentTest.assignCategory(new String[]{t.getName()}));
        Test test = scenarioExtentTest.getModel();
        test.setStartTime(scenario.getStartTime());
        test.setEndTime(scenario.getEndTime());
        scenario.setTestId(test.getId());
        return scenarioExtentTest;
    }

    public ExtentTest createScenarioOutlineExtentNode(ExtentTest parentExtentTest, Scenario scenarioOutline) {
        String uriStepLines = scenarioOutline.getUriStepLines();
        if (this.uriLinesScenarioOutlineTestMap.containsKey(scenarioOutline.getUriStepLines())) {
            return this.uriLinesScenarioOutlineTestMap.get(uriStepLines);
        }
        ExtentTest scenarioOutlineExtentTest = parentExtentTest.createNode(ScenarioOutline.class, this.parseTestNameFromId(scenarioOutline.getId()), scenarioOutline.getDescription());
        this.uriLinesScenarioOutlineTestMap.put(uriStepLines, scenarioOutlineExtentTest);
        return scenarioOutlineExtentTest;
    }

    private String parseTestNameFromId(String id) {
        String[] splits = id.split(";");
        if (splits.length != 4) {
            return id;
        }
        String[] name = splits[1].split("-");
        return Arrays.stream(name).map(t -> {
            if (t.length() == 1) {
                return t.toUpperCase();
            }
            if (t.length() > 1) {
                return t.substring(0, 1).toUpperCase() + t.substring(1);
            }
            return "";
        }).collect(Collectors.joining(" "));
    }

    public ExtentTest createHookExtentNode(ExtentTest parentExtentTest, Hook hook) {
        ExtentTest hookExtentTest = parentExtentTest.createNode(Asterisk.class, hook.getMatch().getLocation(), hook.getHookType().toString().toUpperCase());
        hook.setTestId(hookExtentTest.getModel().getId());
        hook.getOutput().forEach(o -> hookExtentTest.info(o));
        this.updateTestEmbeddings(hookExtentTest, hook.getEmbeddings());
        this.updateTestLogStatus(hookExtentTest, hook.getResult());
        Test test = hookExtentTest.getModel();
        test.setStartTime(hook.getStartTime());
        test.setEndTime(hook.getEndTime());
        return hookExtentTest;
    }

    public List<ExtentTest> createHookExtentNode(ExtentTest parentExtentTest, List<Hook> hooks) {
        ArrayList<ExtentTest> hookTests = new ArrayList<ExtentTest>();
        if (!this.reportProperties.isDisplayAllHooks()) {
            hooks.removeIf(h -> h.getEmbeddings().isEmpty() && h.getOutput().isEmpty());
        }
        hooks.forEach(h -> hookTests.add(this.createHookExtentNode(parentExtentTest, (Hook)h)));
        return hookTests;
    }

    public List<ExtentTest> createBeforeHookExtentNodes(ExtentTest parentExtentTest, Scenario scenario) {
        return this.createHookExtentNode(parentExtentTest, scenario.getBefore());
    }

    public List<ExtentTest> createAfterHookExtentNodes(ExtentTest parentExtentTest, Scenario scenario) {
        return this.createHookExtentNode(parentExtentTest, scenario.getAfter());
    }

    public List<ExtentTest> createBeforeStepHookExtentNodes(ExtentTest parentExtentTest, Step step) {
        return this.createHookExtentNode(parentExtentTest, step.getBefore());
    }

    public List<ExtentTest> createAfterStepHookExtentNodes(ExtentTest parentExtentTest, Step step) {
        return this.createHookExtentNode(parentExtentTest, step.getAfter());
    }

    public ExtentTest createStepExtentNode(ExtentTest parentExtentTest, Step step) {
        ExtentTest stepExtentTest = null;
        GherkinKeyword keyword = null;
        try {
            keyword = new GherkinKeyword("And");
            keyword = new GherkinKeyword(step.getKeyword().trim());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        stepExtentTest = parentExtentTest.createNode(keyword, step.getKeyword() + step.getName(), step.getMatch().getLocation());
        step.setTestId(stepExtentTest.getModel().getId());
        Test test = stepExtentTest.getModel();
        test.setStartTime(step.getStartTime());
        test.setEndTime(step.getEndTime());
        if (step.getRows().size() > 0) {
            stepExtentTest.pass(step.getDataTableMarkup());
        }
        if (step.getDocStringMarkup() != null) {
            stepExtentTest.pass(step.getDocStringMarkup());
        }
        for (String msg : step.getOutput()) {
            stepExtentTest.info(msg);
        }
        if (step.getEmbeddings().size() > 0) {
            this.updateTestEmbeddings(stepExtentTest, step.getEmbeddings());
        }
        this.updateTestLogStatus(stepExtentTest, step.getResult());
        return stepExtentTest;
    }

    public void updateTestEmbeddings(ExtentTest test, List<Embedded> embeddings) {
        this.embeddedProcessor.updateExtentTestWithEmbedding(test, embeddings);
    }

    public void updateTestLogStatus(ExtentTest test, Result result) {
        String stepStatus = result.getStatus();
        if (stepStatus.equalsIgnoreCase("failed")) {
            test.fail(MarkupHelper.createCodeBlock((String)result.getErrorMessage()));
        } else if (stepStatus.equalsIgnoreCase("passed")) {
            test.pass("");
        } else if (stepStatus.equalsIgnoreCase("undefined") && this.reportProperties.isStrictCucumber6Behavior()) {
            test.fail(MarkupHelper.createCodeBlock((String)"Step is undefined"));
        } else if (stepStatus.equalsIgnoreCase("undefined")) {
            test.skip(MarkupHelper.createCodeBlock((String)"Step is undefined"));
        } else if (stepStatus.equalsIgnoreCase("pending") && this.reportProperties.isStrictCucumber6Behavior()) {
            test.fail(MarkupHelper.createCodeBlock((String)result.getErrorMessage()));
        } else if (stepStatus.equalsIgnoreCase("pending")) {
            test.skip(MarkupHelper.createCodeBlock((String)result.getErrorMessage()));
        } else if (stepStatus.equalsIgnoreCase("skipped") && result.getErrorMessage() != null) {
            test.skip(MarkupHelper.createCodeBlock((String)result.getErrorMessage()));
        } else {
            test.skip("");
        }
    }
}

