/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.internetenvsetting;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import tech.guazi.component.internetenvsetting.OnHostChangedListener;
import tech.guazi.component.internetenvsetting.SelectHostActivity;

public class HostChangedManager {
    OnHostChangedListener listener = null;
    private static HostChangedManager mInstance = null;
    public static final String HOST_KEY = "host_key";
    private final String ONLINE_HOST = "http://api.guazi.com";
    private final String WEB6_HOST = "http://web6api.dns.ganji.com:82";
    public final String TEST_HOST = "http://test1.api.guazi.tech";
    private final String ONLINE_KEY = "online_key";
    private final String WEB6_KEY = "web6_key";
    private final String TEST_KEY = "test_key";
    private final String DEFAULT_PREFERENCE = "environment_host";
    private String localTestHost;
    private String localWeb6Host;
    private String localOnlineHost;
    private Context context;
    private Environment environment = Environment.ONLINE;
    private SharedPreferences sharedPreferences;
    private SharedPreferences.Editor editor;

    private HostChangedManager() {
    }

    public static synchronized HostChangedManager getInstance() {
        if (mInstance == null) {
            mInstance = new HostChangedManager();
        }
        return mInstance;
    }

    public void init(Context ctx) {
        this.context = ctx;
        if (this.sharedPreferences == null) {
            this.sharedPreferences = this.context.getSharedPreferences("environment_host", 0);
            this.editor = this.sharedPreferences.edit();
        }
        if (TextUtils.isEmpty((CharSequence)this.sharedPreferences.getString("test_key", null))) {
            this.editor.putString("test_key", "http://test1.api.guazi.tech");
            this.editor.putString("web6_key", "http://web6api.dns.ganji.com:82");
            this.editor.putString("online_key", "http://api.guazi.com");
            this.editor.apply();
        }
        this.localTestHost = this.sharedPreferences.getString("test_key", null);
        this.localWeb6Host = this.sharedPreferences.getString("web6_key", null);
        this.localOnlineHost = this.sharedPreferences.getString("online_key", null);
        String targetHost = this.getHost();
        if (TextUtils.equals((CharSequence)this.localTestHost, (CharSequence)targetHost)) {
            this.environment = Environment.TEST;
        } else if (TextUtils.equals((CharSequence)this.localWeb6Host, (CharSequence)targetHost)) {
            this.environment = Environment.WEB6;
        } else if (TextUtils.equals((CharSequence)this.localOnlineHost, (CharSequence)targetHost)) {
            this.environment = Environment.ONLINE;
        }
    }

    public String getHost() {
        SharedPreferences sp = this.context.getSharedPreferences("environment_host", 0);
        return sp.getString(HOST_KEY, "http://api.guazi.com");
    }

    public void startSelectHostActivity(OnHostChangedListener listener) {
        Intent intent = new Intent(this.context, SelectHostActivity.class);
        intent.setFlags(0x10800000);
        this.listener = listener;
        this.context.startActivity(intent);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getHost(Environment env) {
        String host = "";
        switch (env) {
            case TEST: {
                host = this.localTestHost;
                break;
            }
            case WEB6: {
                host = this.localWeb6Host;
                break;
            }
            case ONLINE: {
                host = this.localOnlineHost;
            }
        }
        return host;
    }

    void saveHost(String testHost, String web6Host, String onLineHost) {
        if (!this.localTestHost.equals(testHost)) {
            this.localTestHost = testHost;
            this.editor.putString("test_key", testHost);
        }
        if (!this.localWeb6Host.equals(web6Host)) {
            this.localWeb6Host = web6Host;
            this.editor.putString("web6_key", web6Host);
        }
        if (!this.localOnlineHost.equals(onLineHost)) {
            this.localOnlineHost = onLineHost;
            this.editor.putString("online_key", onLineHost);
        }
    }

    void saveTargetHost(Environment evn) {
        this.environment = evn;
        this.editor.putString(HOST_KEY, this.getHost(this.environment));
        this.editor.apply();
        if (this.listener != null) {
            this.listener.onHostChanged(evn, this.getHost(evn));
        }
    }

    void cleanHost() {
        this.editor.putString(HOST_KEY, null);
        this.editor.apply();
    }

    public static enum Environment {
        TEST,
        WEB6,
        ONLINE;

    }
}

