/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.internetenvsetting;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Toast;
import tech.guazi.component.internetenvsetting.HostChangedManager;
import tech.guazi.component.internetenvsetting.R;

public class SelectHostActivity
extends Activity {
    private ImageView backView;
    private RadioGroup rgRadioGroup;
    private RadioButton rbtnTest;
    private RadioButton rbtnWeb6;
    private RadioButton rbtnOnline;
    private EditText testMsg;
    private EditText web6Msg;
    private EditText onlineMsg;
    private Button saveHost;
    private Button clearHost;
    private View.OnClickListener onClicked = new View.OnClickListener(){

        public void onClick(View v) {
            int id2 = v.getId();
            HostChangedManager.Environment environment = HostChangedManager.Environment.ONLINE;
            String testHost = SelectHostActivity.this.testMsg.getText().toString();
            String web6Host = SelectHostActivity.this.web6Msg.getText().toString();
            String onLineHost = SelectHostActivity.this.onlineMsg.getText().toString();
            if (id2 == R.id.btn_save) {
                if (SelectHostActivity.this.rgRadioGroup.getCheckedRadioButtonId() == R.id.rbtn_test) {
                    environment = HostChangedManager.Environment.TEST;
                } else if (SelectHostActivity.this.rgRadioGroup.getCheckedRadioButtonId() == R.id.rbtn_web_6) {
                    environment = HostChangedManager.Environment.WEB6;
                } else if (SelectHostActivity.this.rgRadioGroup.getCheckedRadioButtonId() == R.id.rbtn_online) {
                    environment = HostChangedManager.Environment.ONLINE;
                } else {
                    Toast.makeText((Context)SelectHostActivity.this, (CharSequence)"\u8bf7\u9009\u62e9\u4e00\u4e2aHOST\u8fdb\u884c\u4fdd\u5b58!", (int)0).show();
                    return;
                }
                HostChangedManager.getInstance().saveHost(testHost, web6Host, onLineHost);
                HostChangedManager.getInstance().saveTargetHost(environment);
                SelectHostActivity.this.finish();
            } else if (id2 == R.id.btn_clear) {
                HostChangedManager.getInstance().cleanHost();
                SelectHostActivity.this.finish();
            } else if (id2 == R.id.iv_back) {
                SelectHostActivity.this.finish();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_select_host);
        this.initView();
    }

    private void initView() {
        this.backView = (ImageView)this.findViewById(R.id.iv_back);
        this.rgRadioGroup = (RadioGroup)this.findViewById(R.id.rg_radio_group);
        this.rbtnTest = (RadioButton)this.findViewById(R.id.rbtn_test);
        this.rbtnWeb6 = (RadioButton)this.findViewById(R.id.rbtn_web_6);
        this.rbtnOnline = (RadioButton)this.findViewById(R.id.rbtn_online);
        this.testMsg = (EditText)this.findViewById(R.id.et_test);
        this.web6Msg = (EditText)this.findViewById(R.id.et_web_6);
        this.onlineMsg = (EditText)this.findViewById(R.id.et_online);
        this.saveHost = (Button)this.findViewById(R.id.btn_save);
        this.clearHost = (Button)this.findViewById(R.id.btn_clear);
        this.testMsg.setText((CharSequence)HostChangedManager.getInstance().getHost(HostChangedManager.Environment.TEST));
        this.web6Msg.setText((CharSequence)HostChangedManager.getInstance().getHost(HostChangedManager.Environment.WEB6));
        this.onlineMsg.setText((CharSequence)HostChangedManager.getInstance().getHost(HostChangedManager.Environment.ONLINE));
        switch (HostChangedManager.getInstance().getEnvironment()) {
            case TEST: {
                this.rbtnTest.setChecked(true);
                break;
            }
            case WEB6: {
                this.rbtnWeb6.setChecked(true);
                break;
            }
            case ONLINE: {
                this.rbtnOnline.setChecked(true);
                break;
            }
        }
        this.saveHost.setOnClickListener(this.onClicked);
        this.backView.setOnClickListener(this.onClicked);
        this.clearHost.setOnClickListener(this.onClicked);
    }
}

