/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import me.nereo.multi_image_selector.MultiImageSelectorFragment;
import me.nereo.multi_image_selector.R;

public class MultiImageSelectorActivity
extends FragmentActivity
implements MultiImageSelectorFragment.Callback {
    public static final String EXTRA_SELECT_COUNT = "max_select_count";
    public static final String EXTRA_SELECT_MODE = "select_count_mode";
    public static final String EXTRA_SHOW_CAMERA = "show_camera";
    public static final String EXTRA_RESULT = "select_result";
    public static final String EXTRA_DEFAULT_SELECTED_LIST = "default_list";
    public static final int MODE_SINGLE = 0;
    public static final int MODE_MULTI = 1;
    private ArrayList<String> resultList = new ArrayList();
    private TextView mSubmitButton;
    private int mDefaultCount;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_default);
        Intent intent = this.getIntent();
        this.mDefaultCount = intent.getIntExtra(EXTRA_SELECT_COUNT, 9);
        int mode = intent.getIntExtra(EXTRA_SELECT_MODE, 1);
        boolean isShow = intent.getBooleanExtra(EXTRA_SHOW_CAMERA, true);
        if (mode == 1 && intent.hasExtra(EXTRA_DEFAULT_SELECTED_LIST)) {
            this.resultList = intent.getStringArrayListExtra(EXTRA_DEFAULT_SELECTED_LIST);
        }
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA_SELECT_COUNT, this.mDefaultCount);
        bundle.putInt(EXTRA_SELECT_MODE, mode);
        bundle.putBoolean(EXTRA_SHOW_CAMERA, isShow);
        bundle.putStringArrayList("default_result", this.resultList);
        this.getSupportFragmentManager().beginTransaction().add(R.id.image_grid, Fragment.instantiate((Context)this, (String)MultiImageSelectorFragment.class.getName(), (Bundle)bundle)).commit();
        this.findViewById(R.id.btn_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MultiImageSelectorActivity.this.setResult(0);
                MultiImageSelectorActivity.this.finish();
            }
        });
        this.mSubmitButton = (TextView)this.findViewById(R.id.commit);
        if (this.resultList == null || this.resultList.size() <= 0) {
            this.mSubmitButton.setText((CharSequence)"\u5b8c\u6210");
            this.mSubmitButton.setEnabled(false);
        } else {
            this.mSubmitButton.setText((CharSequence)("\u5b8c\u6210(" + this.resultList.size() + "/" + this.mDefaultCount + ")"));
            this.mSubmitButton.setEnabled(true);
        }
        this.mSubmitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MultiImageSelectorActivity.this.resultList != null && MultiImageSelectorActivity.this.resultList.size() > 0) {
                    Intent data = new Intent();
                    data.putStringArrayListExtra(MultiImageSelectorActivity.EXTRA_RESULT, MultiImageSelectorActivity.this.resultList);
                    MultiImageSelectorActivity.this.setResult(-1, data);
                    MultiImageSelectorActivity.this.finish();
                }
            }
        });
    }

    @Override
    public void onSingleImageSelected(String path) {
        Intent data = new Intent();
        this.resultList.add(path);
        data.putStringArrayListExtra(EXTRA_RESULT, this.resultList);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onImageSelected(String path) {
        if (!this.resultList.contains(path)) {
            this.resultList.add(path);
        }
        if (this.resultList.size() > 0) {
            this.mSubmitButton.setText((CharSequence)("\u5b8c\u6210(" + this.resultList.size() + "/" + this.mDefaultCount + ")"));
            if (!this.mSubmitButton.isEnabled()) {
                this.mSubmitButton.setEnabled(true);
            }
        }
    }

    @Override
    public void onImageUnselected(String path) {
        if (this.resultList.contains(path)) {
            this.resultList.remove(path);
            this.mSubmitButton.setText((CharSequence)("\u5b8c\u6210(" + this.resultList.size() + "/" + this.mDefaultCount + ")"));
        } else {
            this.mSubmitButton.setText((CharSequence)("\u5b8c\u6210(" + this.resultList.size() + "/" + this.mDefaultCount + ")"));
        }
        if (this.resultList.size() == 0) {
            this.mSubmitButton.setText((CharSequence)"\u5b8c\u6210");
            this.mSubmitButton.setEnabled(false);
        }
    }

    @Override
    public void onCameraShot(File imageFile) {
        if (imageFile != null) {
            Intent data = new Intent();
            this.resultList.add(imageFile.getAbsolutePath());
            data.putStringArrayListExtra(EXTRA_RESULT, this.resultList);
            this.setResult(-1, data);
            this.finish();
        }
    }
}

