/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.bean.Folder;

public class FolderAdapter
extends BaseAdapter {
    private Context mContext;
    private LayoutInflater mInflater;
    private List<Folder> mFolders = new ArrayList<Folder>();
    int mImageSize;
    int lastSelected = 0;

    public FolderAdapter(Context context) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mImageSize = this.mContext.getResources().getDimensionPixelOffset(R.dimen.folder_cover_size);
    }

    public void setData(List<Folder> folders) {
        if (folders != null && folders.size() > 0) {
            this.mFolders = folders;
        } else {
            this.mFolders.clear();
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mFolders.size() + 1;
    }

    public Folder getItem(int i) {
        if (i == 0) {
            return null;
        }
        return this.mFolders.get(i - 1);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        ViewHolder holder;
        if (view == null) {
            view = this.mInflater.inflate(R.layout.list_item_folder, viewGroup, false);
            holder = new ViewHolder(view);
        } else {
            holder = (ViewHolder)view.getTag();
        }
        if (holder != null) {
            if (i == 0) {
                holder.name.setText((CharSequence)"\u6240\u6709\u7167\u7247");
                holder.size.setText((CharSequence)(this.getTotalImageSize() + "\u5f20"));
                if (this.mFolders.size() > 0) {
                    Folder f = this.mFolders.get(0);
                    Picasso.with((Context)this.mContext).load(new File(f.cover.path)).error(R.drawable.default_error).resize(this.mImageSize, this.mImageSize).centerCrop().into(holder.cover);
                }
            } else {
                holder.bindData(this.getItem(i));
            }
            if (this.lastSelected == i) {
                holder.indicator.setVisibility(0);
            } else {
                holder.indicator.setVisibility(4);
            }
        }
        return view;
    }

    private int getTotalImageSize() {
        int result = 0;
        if (this.mFolders != null && this.mFolders.size() > 0) {
            for (Folder f : this.mFolders) {
                result += f.images.size();
            }
        }
        return result;
    }

    public void setSelectIndex(int i) {
        if (this.lastSelected == i) {
            return;
        }
        this.lastSelected = i;
        this.notifyDataSetChanged();
    }

    public int getSelectIndex() {
        return this.lastSelected;
    }

    class ViewHolder {
        ImageView cover;
        TextView name;
        TextView size;
        ImageView indicator;

        ViewHolder(View view) {
            this.cover = (ImageView)view.findViewById(R.id.cover);
            this.name = (TextView)view.findViewById(R.id.name);
            this.size = (TextView)view.findViewById(R.id.size);
            this.indicator = (ImageView)view.findViewById(R.id.indicator);
            view.setTag((Object)this);
        }

        void bindData(Folder data) {
            this.name.setText((CharSequence)data.name);
            this.size.setText((CharSequence)(data.images.size() + "\u5f20"));
            Picasso.with((Context)FolderAdapter.this.mContext).load(new File(data.cover.path)).placeholder(R.drawable.default_error).resize(FolderAdapter.this.mImageSize, FolderAdapter.this.mImageSize).centerCrop().into(this.cover);
        }
    }
}

