/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import me.nereo.multi_image_selector.MultiImageSelectorFragment;
import me.nereo.multi_image_selector.PhotoPreviewActivity;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.SelectorFinal;
import me.nereo.multi_image_selector.config.FunctionConfig;

public class MultiImageSelectorActivity
extends FragmentActivity
implements MultiImageSelectorFragment.Callback,
View.OnClickListener {
    public static final String EXTRA_SELECT_COUNT = "max_select_count";
    public static final String EXTRA_SELECT_MODE = "select_count_mode";
    public static final String EXTRA_SHOW_CAMERA = "show_camera";
    public static final String EXTRA_RESULT = "select_result";
    public static final String EXTRA_DEFAULT_SELECTED_LIST = "default_list";
    public static final int MODE_SINGLE = 0;
    public static final int MODE_MULTI = 1;
    private static final String FRAGMENT_TAG = "MultiFragment";
    private ArrayList<String> resultList = new ArrayList();
    private int mDefaultCount;
    private View mTitleBar;
    private TextView mTitleName;
    private TextView mTvChooseCount;
    private ImageView mIvBack;
    private ImageView mIvClear;
    private ImageView mIvPreview;
    private FunctionConfig mFunctionConfig;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_default);
        this.mFunctionConfig = SelectorFinal.getFunctionConfig();
        Intent intent = this.getIntent();
        this.mDefaultCount = this.mFunctionConfig.getMaxSize();
        int mode = this.mFunctionConfig.isEnableMutiSelect() ? 1 : 0;
        boolean isShow = this.mFunctionConfig.isEnableCamera();
        if (mode == 1 && intent.hasExtra(EXTRA_DEFAULT_SELECTED_LIST)) {
            this.resultList = intent.getStringArrayListExtra(EXTRA_DEFAULT_SELECTED_LIST);
        }
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA_SELECT_COUNT, this.mDefaultCount);
        bundle.putInt(EXTRA_SELECT_MODE, mode);
        bundle.putBoolean(EXTRA_SHOW_CAMERA, isShow);
        bundle.putStringArrayList("default_result", this.resultList);
        this.getSupportFragmentManager().beginTransaction().add(R.id.image_grid, Fragment.instantiate((Context)this, (String)MultiImageSelectorFragment.class.getName(), (Bundle)bundle), FRAGMENT_TAG).commit();
        this.findViews();
        this.setTheme();
        this.refreshSelectCount();
    }

    private void findViews() {
        this.mTitleBar = this.findViewById(R.id.rl_root_titlebar);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_back);
        this.mTitleName = (TextView)this.findViewById(R.id.tv_titlename);
        this.mTvChooseCount = (TextView)this.findViewById(R.id.tv_choose_count);
        this.mIvClear = (ImageView)this.findViewById(R.id.iv_clear);
        this.mIvPreview = (ImageView)this.findViewById(R.id.iv_preview);
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvPreview.setOnClickListener((View.OnClickListener)this);
        this.mIvClear.setOnClickListener((View.OnClickListener)this);
        this.mTvChooseCount.setOnClickListener((View.OnClickListener)this);
    }

    private void setTheme() {
        this.mTitleBar.setBackgroundColor(SelectorFinal.getGalleryTheme().getTitleBarBgColor());
        this.mTitleName.setTextColor(SelectorFinal.getGalleryTheme().getTitleBarTextColor());
        this.mTvChooseCount.setText((CharSequence)this.getString(R.string.selected, new Object[]{this.resultList.size(), this.mDefaultCount}));
        this.mTvChooseCount.setTextColor(SelectorFinal.getGalleryTheme().getTitleBarTextColor());
        if (this.resultList == null || this.resultList.size() <= 0) {
            this.mTvChooseCount.setEnabled(false);
        } else {
            this.mTvChooseCount.setEnabled(true);
        }
    }

    private void refreshSelectCount() {
        this.mTvChooseCount.setText((CharSequence)this.getString(R.string.selected, new Object[]{this.resultList.size(), this.mDefaultCount}));
        if (this.resultList.size() > 0 && this.mFunctionConfig.isEnableMutiSelect()) {
            this.mIvClear.setVisibility(0);
            if (this.mFunctionConfig.isEnablePreview()) {
                this.mIvPreview.setVisibility(0);
            }
        } else {
            this.mIvClear.setVisibility(8);
            this.mIvPreview.setVisibility(8);
        }
    }

    @Override
    public void onSingleImageSelected(String path) {
        Intent data = new Intent();
        this.resultList.add(path);
        data.putStringArrayListExtra(EXTRA_RESULT, this.resultList);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onImageSelected(String path) {
        if (!this.resultList.contains(path)) {
            this.resultList.add(path);
        }
        if (this.resultList.size() > 0) {
            this.mTvChooseCount.setText((CharSequence)this.getString(R.string.selected, new Object[]{this.resultList.size(), this.mDefaultCount}));
            if (!this.mTvChooseCount.isEnabled()) {
                this.mTvChooseCount.setEnabled(true);
            }
        }
        this.refreshSelectCount();
    }

    @Override
    public void onImageUnselected(String path) {
        if (this.resultList.contains(path)) {
            this.resultList.remove(path);
            this.mTvChooseCount.setText((CharSequence)this.getString(R.string.selected, new Object[]{this.resultList.size(), this.mDefaultCount}));
        } else {
            this.mTvChooseCount.setText((CharSequence)this.getString(R.string.selected, new Object[]{this.resultList.size(), this.mDefaultCount}));
        }
        if (this.resultList.size() == 0) {
            this.mTvChooseCount.setText((CharSequence)this.getString(R.string.selected, new Object[]{this.resultList.size(), this.mDefaultCount}));
            this.mTvChooseCount.setEnabled(false);
        }
        this.refreshSelectCount();
    }

    @Override
    public void onCameraShot(File imageFile) {
        if (imageFile != null) {
            Intent data = new Intent();
            this.resultList.add(imageFile.getAbsolutePath());
            data.putStringArrayListExtra(EXTRA_RESULT, this.resultList);
            this.setResult(-1, data);
            this.finish();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.iv_back) {
            this.setResult(0);
            this.finish();
        } else if (id2 == R.id.iv_clear) {
            MultiImageSelectorFragment mMultiFragment = (MultiImageSelectorFragment)this.getSupportFragmentManager().findFragmentByTag(FRAGMENT_TAG);
            mMultiFragment.clearSelectImage();
            this.resultList.clear();
            this.refreshSelectCount();
        } else if (id2 == R.id.iv_preview) {
            if (this.resultList != null && this.resultList.size() > 0) {
                Intent intent = new Intent();
                intent.setClass((Context)this, PhotoPreviewActivity.class);
                intent.putStringArrayListExtra("photo_list", this.resultList);
                this.startActivity(intent);
            }
        } else if (id2 == R.id.tv_choose_count && this.resultList != null && this.resultList.size() > 0) {
            SelectorFinal.getCallback().onHandlerSuccess(this.resultList);
            this.finish();
        }
    }
}

