/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.adapter.FolderAdapter;
import me.nereo.multi_image_selector.adapter.ImageGridAdapter;
import me.nereo.multi_image_selector.bean.Folder;
import me.nereo.multi_image_selector.bean.Image;
import me.nereo.multi_image_selector.utils.FileUtils;
import me.nereo.multi_image_selector.utils.TimeUtils;

public class MultiImageSelectorFragment
extends Fragment {
    private static final String TAG = "MultiImageSelector";
    public static final String EXTRA_SELECT_COUNT = "max_select_count";
    public static final String EXTRA_SELECT_MODE = "select_count_mode";
    public static final String EXTRA_SHOW_CAMERA = "show_camera";
    public static final String EXTRA_DEFAULT_SELECTED_LIST = "default_result";
    public static final int MODE_SINGLE = 0;
    public static final int MODE_MULTI = 1;
    private static final int LOADER_ALL = 0;
    private static final int LOADER_CATEGORY = 1;
    private static final int REQUEST_CAMERA = 100;
    private ArrayList<String> resultList = new ArrayList();
    private ArrayList<Folder> mResultFolder = new ArrayList();
    private GridView mGridView;
    private Callback mCallback;
    private ImageGridAdapter mImageAdapter;
    private FolderAdapter mFolderAdapter;
    private ListPopupWindow mFolderPopupWindow;
    private TextView mTimeLineText;
    private TextView mCategoryText;
    private Button mPreviewBtn;
    private View mPopupAnchorView;
    private int mDesireImageCount;
    private boolean hasFolderGened = false;
    private boolean mIsShowCamera = false;
    private int mGridWidth;
    private int mGridHeight;
    private File mTmpFile;
    private LoaderManager.LoaderCallbacks<Cursor> mLoaderCallback = new LoaderManager.LoaderCallbacks<Cursor>(){
        private final String[] IMAGE_PROJECTION = new String[]{"_data", "_display_name", "date_added", "_id"};

        public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
            if (id2 == 0) {
                CursorLoader cursorLoader = new CursorLoader((Context)MultiImageSelectorFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, null, null, this.IMAGE_PROJECTION[2] + " DESC");
                return cursorLoader;
            }
            if (id2 == 1) {
                CursorLoader cursorLoader = new CursorLoader((Context)MultiImageSelectorFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, this.IMAGE_PROJECTION[0] + " like '%" + args.getString("path") + "%'", null, this.IMAGE_PROJECTION[2] + " DESC");
                return cursorLoader;
            }
            return null;
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
            String[] mFilterDirs = MultiImageSelectorFragment.this.getResources().getStringArray(R.array.filter_out_dirs);
            if (data != null) {
                ArrayList<Image> images = new ArrayList<Image>();
                int count = data.getCount();
                if (count > 0) {
                    data.moveToFirst();
                    do {
                        File imageFile;
                        String imageParentName;
                        String path = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[0]));
                        String name = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[1]));
                        long dateTime = data.getLong(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[2]));
                        Image image = new Image(path, name, dateTime);
                        File file = new File(path);
                        if (file.exists() && !MultiImageSelectorFragment.this.isFilterOutDir(imageParentName = file.getParentFile().getName(), mFilterDirs)) {
                            images.add(image);
                        }
                        if (MultiImageSelectorFragment.this.hasFolderGened || !(imageFile = new File(path)).exists()) continue;
                        File folderFile = imageFile.getParentFile();
                        Folder folder = new Folder();
                        folder.name = folderFile.getName();
                        folder.path = folderFile.getAbsolutePath();
                        folder.cover = image;
                        if (!MultiImageSelectorFragment.this.mResultFolder.contains(folder)) {
                            ArrayList<Image> imageList = new ArrayList<Image>();
                            if (MultiImageSelectorFragment.this.isFilterOutDir(folder.name, mFilterDirs)) continue;
                            imageList.add(image);
                            folder.images = imageList;
                            MultiImageSelectorFragment.this.mResultFolder.add(folder);
                            continue;
                        }
                        Folder f = (Folder)MultiImageSelectorFragment.this.mResultFolder.get(MultiImageSelectorFragment.this.mResultFolder.indexOf(folder));
                        if (MultiImageSelectorFragment.this.isFilterOutDir(folder.name, mFilterDirs)) continue;
                        f.images.add(image);
                    } while (data.moveToNext());
                    MultiImageSelectorFragment.this.mImageAdapter.setData(images);
                    if (MultiImageSelectorFragment.this.resultList != null && MultiImageSelectorFragment.this.resultList.size() > 0) {
                        MultiImageSelectorFragment.this.mImageAdapter.setDefaultSelected(MultiImageSelectorFragment.this.resultList);
                    }
                    MultiImageSelectorFragment.this.mFolderAdapter.setData(MultiImageSelectorFragment.this.mResultFolder);
                    MultiImageSelectorFragment.this.hasFolderGened = true;
                }
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }
    };

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mCallback = (Callback)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The Activity must implement MultiImageSelectorFragment.Callback interface...");
        }
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_multi_image, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        ArrayList tmp;
        super.onViewCreated(view, savedInstanceState);
        this.mDesireImageCount = this.getArguments().getInt(EXTRA_SELECT_COUNT);
        final int mode = this.getArguments().getInt(EXTRA_SELECT_MODE);
        if (mode == 1 && (tmp = this.getArguments().getStringArrayList(EXTRA_DEFAULT_SELECTED_LIST)) != null && tmp.size() > 0) {
            this.resultList = tmp;
        }
        this.mIsShowCamera = this.getArguments().getBoolean(EXTRA_SHOW_CAMERA, true);
        this.mImageAdapter = new ImageGridAdapter((Context)this.getActivity(), this.mIsShowCamera);
        this.mImageAdapter.showSelectIndicator(mode == 1);
        this.mPopupAnchorView = view.findViewById(R.id.footer);
        this.mTimeLineText = (TextView)view.findViewById(R.id.timeline_area);
        this.mTimeLineText.setVisibility(8);
        this.mCategoryText = (TextView)view.findViewById(R.id.category_btn);
        this.mCategoryText.setText(R.string.folder_all);
        this.mCategoryText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MultiImageSelectorFragment.this.mFolderPopupWindow == null) {
                    MultiImageSelectorFragment.this.createPopupFolderList(MultiImageSelectorFragment.this.mGridWidth, MultiImageSelectorFragment.this.mGridHeight);
                }
                if (MultiImageSelectorFragment.this.mFolderPopupWindow.isShowing()) {
                    MultiImageSelectorFragment.this.mFolderPopupWindow.dismiss();
                } else {
                    MultiImageSelectorFragment.this.mFolderPopupWindow.show();
                    int index = MultiImageSelectorFragment.this.mFolderAdapter.getSelectIndex();
                    index = index == 0 ? index : index - 1;
                    MultiImageSelectorFragment.this.mFolderPopupWindow.getListView().setSelection(index);
                }
            }
        });
        this.mPreviewBtn = (Button)view.findViewById(R.id.preview);
        if (this.resultList == null || this.resultList.size() <= 0) {
            this.mPreviewBtn.setText(R.string.preview);
            this.mPreviewBtn.setEnabled(false);
        }
        this.mPreviewBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
        this.mGridView = (GridView)view.findViewById(R.id.grid);
        this.mGridView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int state) {
                if (state == 0) {
                    MultiImageSelectorFragment.this.mTimeLineText.setVisibility(8);
                } else if (state == 2) {
                    MultiImageSelectorFragment.this.mTimeLineText.setVisibility(0);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (MultiImageSelectorFragment.this.mTimeLineText.getVisibility() == 0) {
                    int index = firstVisibleItem + 1 == ((ListAdapter)view.getAdapter()).getCount() ? ((ListAdapter)view.getAdapter()).getCount() - 1 : firstVisibleItem + 1;
                    Image image = (Image)((ListAdapter)view.getAdapter()).getItem(index);
                    if (image != null) {
                        MultiImageSelectorFragment.this.mTimeLineText.setText((CharSequence)TimeUtils.formatPhotoDate(image.path));
                    }
                }
            }
        });
        this.mGridView.setAdapter((ListAdapter)this.mImageAdapter);
        this.mGridView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                int width = MultiImageSelectorFragment.this.mGridView.getWidth();
                int height = MultiImageSelectorFragment.this.mGridView.getHeight();
                MultiImageSelectorFragment.this.mGridWidth = width;
                MultiImageSelectorFragment.this.mGridHeight = height;
                int desireSize = MultiImageSelectorFragment.this.getResources().getDimensionPixelOffset(R.dimen.image_size);
                int numCount = width / desireSize;
                int columnSpace = MultiImageSelectorFragment.this.getResources().getDimensionPixelOffset(R.dimen.space_size);
                int columnWidth = (width - columnSpace * (numCount - 1)) / numCount;
                MultiImageSelectorFragment.this.mImageAdapter.setItemSize(columnWidth);
                if (Build.VERSION.SDK_INT >= 16) {
                    MultiImageSelectorFragment.this.mGridView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    MultiImageSelectorFragment.this.mGridView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (MultiImageSelectorFragment.this.mImageAdapter.isShowCamera()) {
                    if (i == 0) {
                        MultiImageSelectorFragment.this.showCameraAction();
                    } else {
                        Image image = (Image)adapterView.getAdapter().getItem(i);
                        MultiImageSelectorFragment.this.selectImageFromGrid(image, mode);
                    }
                } else {
                    Image image = (Image)adapterView.getAdapter().getItem(i);
                    MultiImageSelectorFragment.this.selectImageFromGrid(image, mode);
                }
            }
        });
        this.mFolderAdapter = new FolderAdapter((Context)this.getActivity());
    }

    private void createPopupFolderList(int width, int height) {
        this.mFolderPopupWindow = new ListPopupWindow((Context)this.getActivity());
        this.mFolderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mFolderPopupWindow.setAdapter((ListAdapter)this.mFolderAdapter);
        this.mFolderPopupWindow.setContentWidth(width);
        this.mFolderPopupWindow.setWidth(width);
        this.mFolderPopupWindow.setHeight(height * 5 / 8);
        this.mFolderPopupWindow.setAnchorView(this.mPopupAnchorView);
        this.mFolderPopupWindow.setModal(true);
        this.mFolderPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                MultiImageSelectorFragment.this.mFolderAdapter.setSelectIndex(i);
                final int index = i;
                final AdapterView<?> v = adapterView;
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MultiImageSelectorFragment.this.mFolderPopupWindow.dismiss();
                        if (index == 0) {
                            MultiImageSelectorFragment.this.getActivity().getSupportLoaderManager().restartLoader(0, null, MultiImageSelectorFragment.this.mLoaderCallback);
                            MultiImageSelectorFragment.this.mCategoryText.setText(R.string.folder_all);
                            if (MultiImageSelectorFragment.this.mIsShowCamera) {
                                MultiImageSelectorFragment.this.mImageAdapter.setShowCamera(true);
                            } else {
                                MultiImageSelectorFragment.this.mImageAdapter.setShowCamera(false);
                            }
                        } else {
                            Folder folder = (Folder)v.getAdapter().getItem(index);
                            if (null != folder) {
                                MultiImageSelectorFragment.this.mImageAdapter.setData(folder.images);
                                MultiImageSelectorFragment.this.mCategoryText.setText((CharSequence)folder.name);
                                if (MultiImageSelectorFragment.this.resultList != null && MultiImageSelectorFragment.this.resultList.size() > 0) {
                                    MultiImageSelectorFragment.this.mImageAdapter.setDefaultSelected(MultiImageSelectorFragment.this.resultList);
                                }
                            }
                            MultiImageSelectorFragment.this.mImageAdapter.setShowCamera(true);
                        }
                        MultiImageSelectorFragment.this.mGridView.smoothScrollToPosition(0);
                    }
                }, 100L);
            }
        });
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle bundle = new Bundle();
        bundle.putString("path", "");
        this.getActivity().getSupportLoaderManager().initLoader(0, null, this.mLoaderCallback);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            if (resultCode == -1) {
                if (this.mTmpFile != null && this.mCallback != null) {
                    if (Build.VERSION.SDK_INT >= 19) {
                        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                        Uri contentUri = Uri.fromFile((File)this.mTmpFile);
                        mediaScanIntent.setData(contentUri);
                        this.getActivity().sendBroadcast(mediaScanIntent);
                    } else {
                        this.getActivity().sendBroadcast(new Intent("android.intent.action.MEDIA_MOUNTED", Uri.fromFile((File)this.mTmpFile)));
                    }
                    this.mCallback.onCameraShot(this.mTmpFile);
                }
            } else if (this.mTmpFile != null && this.mTmpFile.exists()) {
                this.mTmpFile.delete();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Log.d((String)TAG, (String)"on change");
        if (this.mFolderPopupWindow != null && this.mFolderPopupWindow.isShowing()) {
            this.mFolderPopupWindow.dismiss();
        }
        this.mGridView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                int height = MultiImageSelectorFragment.this.mGridView.getHeight();
                int desireSize = MultiImageSelectorFragment.this.getResources().getDimensionPixelOffset(R.dimen.image_size);
                Log.d((String)MultiImageSelectorFragment.TAG, (String)("Desire Size = " + desireSize));
                int numCount = MultiImageSelectorFragment.this.mGridView.getWidth() / desireSize;
                Log.d((String)MultiImageSelectorFragment.TAG, (String)("Grid Size = " + MultiImageSelectorFragment.this.mGridView.getWidth()));
                Log.d((String)MultiImageSelectorFragment.TAG, (String)("num count = " + numCount));
                int columnSpace = MultiImageSelectorFragment.this.getResources().getDimensionPixelOffset(R.dimen.space_size);
                int columnWidth = (MultiImageSelectorFragment.this.mGridView.getWidth() - columnSpace * (numCount - 1)) / numCount;
                MultiImageSelectorFragment.this.mImageAdapter.setItemSize(columnWidth);
                if (MultiImageSelectorFragment.this.mFolderPopupWindow != null) {
                    MultiImageSelectorFragment.this.mFolderPopupWindow.setHeight(height * 5 / 8);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    MultiImageSelectorFragment.this.mGridView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    MultiImageSelectorFragment.this.mGridView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        super.onConfigurationChanged(newConfig);
    }

    private void showCameraAction() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.mTmpFile = FileUtils.createTmpFile((Context)this.getActivity());
            cameraIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.mTmpFile));
            this.startActivityForResult(cameraIntent, 100);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.msg_no_camera, (int)0).show();
        }
    }

    private void selectImageFromGrid(Image image, int mode) {
        if (image != null) {
            if (mode == 1) {
                if (this.resultList.contains(image.path)) {
                    this.resultList.remove(image.path);
                    if (this.resultList.size() != 0) {
                        this.mPreviewBtn.setEnabled(true);
                        this.mPreviewBtn.setText((CharSequence)(this.getResources().getString(R.string.preview) + "(" + this.resultList.size() + ")"));
                    } else {
                        this.mPreviewBtn.setEnabled(false);
                        this.mPreviewBtn.setText(R.string.preview);
                    }
                    if (this.mCallback != null) {
                        this.mCallback.onImageUnselected(image.path);
                    }
                } else {
                    if (this.mDesireImageCount == this.resultList.size()) {
                        Toast.makeText((Context)this.getActivity(), (int)R.string.msg_amount_limit, (int)0).show();
                        return;
                    }
                    this.resultList.add(image.path);
                    this.mPreviewBtn.setEnabled(true);
                    this.mPreviewBtn.setText((CharSequence)(this.getResources().getString(R.string.preview) + "(" + this.resultList.size() + ")"));
                    if (this.mCallback != null) {
                        this.mCallback.onImageSelected(image.path);
                    }
                }
                this.mImageAdapter.select(image);
            } else if (mode == 0 && this.mCallback != null) {
                this.mCallback.onSingleImageSelected(image.path);
            }
        }
    }

    private boolean isFilterOutDir(String folderName, String[] data) {
        if (null != data && data.length > 0) {
            for (String str : data) {
                if (folderName.compareToIgnoreCase(str) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void clearSelectImage() {
        this.resultList.clear();
        this.mImageAdapter.mSelectedImages.clear();
        this.mImageAdapter.notifyDataSetChanged();
    }

    public static interface Callback {
        public void onSingleImageSelected(String var1);

        public void onImageSelected(String var1);

        public void onImageUnselected(String var1);

        public void onCameraShot(File var1);
    }
}

