/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.List;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.SelectorFinal;
import me.nereo.multi_image_selector.adapter.PhotoPreviewAdapter;
import me.nereo.multi_image_selector.config.ThemeConfig;
import me.nereo.multi_image_selector.widget.GFViewPager;

public class PhotoPreviewActivity
extends Activity
implements ViewPager.OnPageChangeListener {
    static final String PHOTO_LIST = "photo_list";
    private RelativeLayout mTitleBar;
    private ImageView mIvBack;
    private TextView mTvTitle;
    private TextView mTvIndicator;
    private GFViewPager mVpPager;
    private List<String> mPhotoList;
    private PhotoPreviewAdapter mPhotoPreviewAdapter;
    private ThemeConfig mThemeConfig;
    private View.OnClickListener mBackListener = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoPreviewActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mThemeConfig = SelectorFinal.getGalleryTheme();
        if (this.mThemeConfig != null) {
            this.setContentView(R.layout.activity_photo_preview);
            this.findViews();
            this.setListener();
            this.setTheme();
            this.mPhotoList = (List)((Object)this.getIntent().getSerializableExtra(PHOTO_LIST));
            this.mPhotoPreviewAdapter = new PhotoPreviewAdapter(this, this.mPhotoList);
            this.mVpPager.setAdapter(this.mPhotoPreviewAdapter);
        }
    }

    private void findViews() {
        this.mTitleBar = (RelativeLayout)this.findViewById(R.id.titlebar);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_back);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mTvIndicator = (TextView)this.findViewById(R.id.tv_indicator);
        this.mVpPager = (GFViewPager)this.findViewById(R.id.vp_pager);
    }

    private void setListener() {
        this.mVpPager.setOnPageChangeListener(this);
        this.mIvBack.setOnClickListener(this.mBackListener);
    }

    private void setTheme() {
        this.mTitleBar.setBackgroundColor(this.mThemeConfig.getTitleBarBgColor());
        this.mTvTitle.setTextColor(this.mThemeConfig.getTitleBarTextColor());
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mTvIndicator.setText((CharSequence)(position + 1 + "/" + this.mPhotoList.size()));
    }

    public void onPageSelected(int position) {
    }

    public void onPageScrollStateChanged(int state) {
    }
}

