/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import java.util.List;
import me.nereo.multi_image_selector.MultiImageSelectorActivity;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.config.CoreConfig;
import me.nereo.multi_image_selector.config.FunctionConfig;
import me.nereo.multi_image_selector.config.ThemeConfig;

public class SelectorFinal {
    private static CoreConfig mCoreConfig;
    private static FunctionConfig mFunctionConfig;
    private static ThemeConfig mThemeConfig;
    private static OnHandlerResultCallback mCallback;

    public static void init(CoreConfig coreConfig) {
        mThemeConfig = coreConfig.getThemeConfig();
        mCoreConfig = coreConfig;
        mFunctionConfig = coreConfig.getFunctionConfig();
    }

    public static CoreConfig getCoreConfig() {
        return mCoreConfig;
    }

    public static FunctionConfig getFunctionConfig() {
        return mFunctionConfig;
    }

    public static ThemeConfig getGalleryTheme() {
        if (mThemeConfig == null) {
            mThemeConfig = ThemeConfig.DEFAULT;
        }
        return mThemeConfig;
    }

    public static void openGallery(OnHandlerResultCallback callback) {
        if (mCoreConfig == null || mCoreConfig.getImageLoader() == null) {
            Toast.makeText((Context)mCoreConfig.getContext(), (CharSequence)mCoreConfig.getContext().getString(R.string.open_gallery_fail), (int)1).show();
            return;
        }
        mCallback = callback;
        Intent intent = new Intent(mCoreConfig.getContext(), MultiImageSelectorActivity.class);
        intent.addFlags(0x10000000);
        mCoreConfig.getContext().startActivity(intent);
    }

    public static void cleanCacheFile() {
    }

    public static OnHandlerResultCallback getCallback() {
        return mCallback;
    }

    public static interface OnHandlerResultCallback {
        public void onHandlerSuccess(List<String> var1);

        public void onHandlerFailure(String var1);
    }
}

