/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.SelectorFinal;
import me.nereo.multi_image_selector.bean.Image;
import me.nereo.multi_image_selector.widget.zoomview.GFImageView;

public class ImageGridAdapter
extends BaseAdapter {
    private static final int TYPE_CAMERA = 0;
    private static final int TYPE_NORMAL = 1;
    private Context mContext;
    private LayoutInflater mInflater;
    private boolean showCamera = true;
    private boolean showSelectIndicator = true;
    private List<Image> mImages = new ArrayList<Image>();
    public List<Image> mSelectedImages = new ArrayList<Image>();
    private int mItemSize;
    private AbsListView.LayoutParams mItemLayoutParams;

    public ImageGridAdapter(Context context, boolean showCamera) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.showCamera = showCamera;
        this.mItemLayoutParams = new AbsListView.LayoutParams(-1, -1);
    }

    public void showSelectIndicator(boolean b) {
        this.showSelectIndicator = b;
    }

    public void setShowCamera(boolean b) {
        if (this.showCamera == b) {
            return;
        }
        this.showCamera = b;
        this.notifyDataSetChanged();
    }

    public boolean isShowCamera() {
        return this.showCamera;
    }

    public void select(Image image) {
        if (this.mSelectedImages.contains(image)) {
            this.mSelectedImages.remove(image);
        } else {
            this.mSelectedImages.add(image);
        }
        this.notifyDataSetChanged();
    }

    public void setDefaultSelected(ArrayList<String> resultList) {
        for (String path : resultList) {
            Image image = this.getImageByPath(path);
            if (image == null) continue;
            this.mSelectedImages.add(image);
        }
        if (this.mSelectedImages.size() > 0) {
            this.notifyDataSetChanged();
        }
    }

    private Image getImageByPath(String path) {
        if (this.mImages != null && this.mImages.size() > 0) {
            for (Image image : this.mImages) {
                if (!image.path.equalsIgnoreCase(path)) continue;
                return image;
            }
        }
        return null;
    }

    public void setData(List<Image> images) {
        this.mSelectedImages.clear();
        if (images != null && images.size() > 0) {
            this.mImages = images;
        } else {
            this.mImages.clear();
        }
        this.notifyDataSetChanged();
    }

    public void setItemSize(int columnWidth) {
        if (this.mItemSize == columnWidth) {
            return;
        }
        this.mItemSize = columnWidth;
        this.mItemLayoutParams = new AbsListView.LayoutParams(this.mItemSize, this.mItemSize);
        this.notifyDataSetChanged();
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        if (this.showCamera) {
            return position == 0 ? 0 : 1;
        }
        return 1;
    }

    public int getCount() {
        return this.showCamera ? this.mImages.size() + 1 : this.mImages.size();
    }

    public Image getItem(int i) {
        if (this.showCamera) {
            if (i == 0) {
                return null;
            }
            return this.mImages.get(i - 1);
        }
        return this.mImages.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        int type = this.getItemViewType(i);
        if (type == 0) {
            view = this.mInflater.inflate(R.layout.list_item_camera, viewGroup, false);
            view.setTag(null);
        } else if (type == 1) {
            ViewHolde holde;
            if (view == null) {
                view = this.mInflater.inflate(R.layout.list_item_image, viewGroup, false);
                holde = new ViewHolde(view);
            } else {
                holde = (ViewHolde)view.getTag();
                if (holde == null) {
                    view = this.mInflater.inflate(R.layout.list_item_image, viewGroup, false);
                    holde = new ViewHolde(view);
                }
            }
            if (holde != null) {
                holde.bindData(this.getItem(i));
            }
        }
        AbsListView.LayoutParams lp = (AbsListView.LayoutParams)view.getLayoutParams();
        if (lp.height != this.mItemSize) {
            view.setLayoutParams((ViewGroup.LayoutParams)this.mItemLayoutParams);
        }
        return view;
    }

    class ViewHolde {
        GFImageView image;
        ImageView indicator;
        TextView mask;

        ViewHolde(View view) {
            this.image = (GFImageView)view.findViewById(R.id.image);
            this.indicator = (ImageView)view.findViewById(R.id.checkmark);
            this.mask = (TextView)view.findViewById(R.id.mask);
            view.setTag((Object)this);
        }

        void bindData(Image data) {
            if (data == null) {
                return;
            }
            if (ImageGridAdapter.this.showSelectIndicator) {
                this.indicator.setVisibility(0);
                if (ImageGridAdapter.this.mSelectedImages.contains(data)) {
                    int position = ImageGridAdapter.this.mSelectedImages.indexOf(data);
                    this.indicator.setBackgroundColor(SelectorFinal.getGalleryTheme().getCheckSelectedColor());
                    this.mask.setText((CharSequence)("" + (position + 1)));
                    this.mask.setTextColor(Color.parseColor((String)"#ffffff"));
                    this.mask.setVisibility(0);
                } else {
                    this.indicator.setBackgroundColor(SelectorFinal.getGalleryTheme().getCheckNornalColor());
                    this.mask.setVisibility(8);
                }
            } else {
                this.indicator.setVisibility(8);
            }
            File imageFile = new File(data.path);
            if (ImageGridAdapter.this.mItemSize > 0) {
                Drawable defaultDrawable = ImageGridAdapter.this.mContext.getResources().getDrawable(R.drawable.default_error);
                SelectorFinal.getCoreConfig().getImageLoader().displayImage(ImageGridAdapter.this.mContext, data.path, this.image, defaultDrawable, ImageGridAdapter.this.mItemSize, ImageGridAdapter.this.mItemSize);
            }
        }
    }
}

