/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.adapter;

import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;

public abstract class RecyclingPagerAdapter
extends PagerAdapter {
    static final int IGNORE_ITEM_VIEW_TYPE = -1;
    private final RecycleBin recycleBin;

    public RecyclingPagerAdapter() {
        this(new RecycleBin());
    }

    RecyclingPagerAdapter(RecycleBin recycleBin) {
        this.recycleBin = recycleBin;
        recycleBin.setViewTypeCount(this.getViewTypeCount());
    }

    public void notifyDataSetChanged() {
        this.recycleBin.scrapActiveViews();
        super.notifyDataSetChanged();
    }

    public final Object instantiateItem(ViewGroup container, int position) {
        int viewType = this.getItemViewType(position);
        View view = null;
        if (viewType != -1) {
            view = this.recycleBin.getScrapView(position, viewType);
        }
        view = this.getView(position, view, container);
        container.addView(view);
        return view;
    }

    public final void destroyItem(ViewGroup container, int position, Object object) {
        View view = (View)object;
        container.removeView(view);
        int viewType = this.getItemViewType(position);
        if (viewType != -1) {
            this.recycleBin.addScrapView(view, position, viewType);
        }
    }

    public final boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public abstract View getView(int var1, View var2, ViewGroup var3);

    public static class RecycleBin {
        private View[] activeViews = new View[0];
        private int[] activeViewTypes = new int[0];
        private SparseArray<View>[] scrapViews;
        private int viewTypeCount;
        private SparseArray<View> currentScrapViews;

        public void setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            SparseArray[] scrapViews = new SparseArray[viewTypeCount];
            for (int i = 0; i < viewTypeCount; ++i) {
                scrapViews[i] = new SparseArray();
            }
            this.viewTypeCount = viewTypeCount;
            this.currentScrapViews = scrapViews[0];
            this.scrapViews = scrapViews;
        }

        protected boolean shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        View getScrapView(int position, int viewType) {
            if (this.viewTypeCount == 1) {
                return RecycleBin.retrieveFromScrap(this.currentScrapViews, position);
            }
            if (viewType >= 0 && viewType < this.scrapViews.length) {
                return RecycleBin.retrieveFromScrap(this.scrapViews[viewType], position);
            }
            return null;
        }

        void addScrapView(View scrap, int position, int viewType) {
            if (this.viewTypeCount == 1) {
                this.currentScrapViews.put(position, (Object)scrap);
            } else {
                this.scrapViews[viewType].put(position, (Object)scrap);
            }
            if (Build.VERSION.SDK_INT >= 14) {
                scrap.setAccessibilityDelegate(null);
            }
        }

        void scrapActiveViews() {
            View[] activeViews = this.activeViews;
            int[] activeViewTypes = this.activeViewTypes;
            boolean multipleScraps = this.viewTypeCount > 1;
            SparseArray<View> scrapViews = this.currentScrapViews;
            int count = activeViews.length;
            for (int i = count - 1; i >= 0; --i) {
                View victim = activeViews[i];
                if (victim == null) continue;
                int whichScrap = activeViewTypes[i];
                activeViews[i] = null;
                activeViewTypes[i] = -1;
                if (!this.shouldRecycleViewType(whichScrap)) continue;
                if (multipleScraps) {
                    scrapViews = this.scrapViews[whichScrap];
                }
                scrapViews.put(i, (Object)victim);
                if (Build.VERSION.SDK_INT < 14) continue;
                victim.setAccessibilityDelegate(null);
            }
            this.pruneScrapViews();
        }

        private void pruneScrapViews() {
            int maxViews = this.activeViews.length;
            int viewTypeCount = this.viewTypeCount;
            SparseArray<View>[] scrapViews = this.scrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                SparseArray<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                int extras = size - maxViews;
                --size;
                for (int j = 0; j < extras; ++j) {
                    scrapPile.remove(scrapPile.keyAt(size--));
                }
            }
        }

        static View retrieveFromScrap(SparseArray<View> scrapViews, int position) {
            int size = scrapViews.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    int fromPosition = scrapViews.keyAt(i);
                    View view = (View)scrapViews.get(fromPosition);
                    if (fromPosition != position) continue;
                    scrapViews.remove(fromPosition);
                    return view;
                }
                int index = size - 1;
                View r = (View)scrapViews.valueAt(index);
                scrapViews.remove(scrapViews.keyAt(index));
                return r;
            }
            return null;
        }
    }
}

