/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.config;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import me.nereo.multi_image_selector.GZImageLoader;
import me.nereo.multi_image_selector.config.FunctionConfig;
import me.nereo.multi_image_selector.config.ThemeConfig;

public class CoreConfig {
    public static final String SAVE_DIR = "guazi";
    private Context context;
    private ThemeConfig themeConfig;
    private boolean debug;
    private GZImageLoader imageLoader;
    private File takePhotoFolder;
    private FunctionConfig mFunctionConfig;

    public CoreConfig(Builder builder) {
        this.context = builder.context;
        this.themeConfig = builder.themeConfig;
        this.debug = builder.debug;
        this.imageLoader = builder.imageLoader;
        this.takePhotoFolder = builder.takePhotoFolder;
        this.mFunctionConfig = builder.mFunctionConfig;
        if (this.takePhotoFolder == null) {
            this.takePhotoFolder = new File(Environment.getExternalStorageDirectory(), SAVE_DIR);
        }
        if (!this.takePhotoFolder.exists()) {
            this.takePhotoFolder.mkdirs();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public ThemeConfig getThemeConfig() {
        return this.themeConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public GZImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public File getTakePhotoFolder() {
        return this.takePhotoFolder;
    }

    public FunctionConfig getFunctionConfig() {
        return this.mFunctionConfig;
    }

    public static class Builder {
        private Context context;
        private ThemeConfig themeConfig;
        private boolean debug;
        private GZImageLoader imageLoader;
        private File takePhotoFolder;
        private FunctionConfig mFunctionConfig;

        public Builder(Context context, GZImageLoader imageLoader, ThemeConfig themeConfig) {
            this.context = context;
            this.imageLoader = imageLoader;
            this.themeConfig = themeConfig;
        }

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setThemeConfig(ThemeConfig themeConfig) {
            this.themeConfig = themeConfig;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder setImageLoader(GZImageLoader imageLoader) {
            this.imageLoader = imageLoader;
            return this;
        }

        public Builder setTakePhotoFolder(File takePhotoFolder) {
            this.takePhotoFolder = takePhotoFolder;
            return this;
        }

        public Builder setFunctionConfig(FunctionConfig mFunctionConfig) {
            this.mFunctionConfig = mFunctionConfig;
            return this;
        }

        public CoreConfig build() {
            return new CoreConfig(this);
        }
    }
}

