/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.config;

import java.util.ArrayList;

public class FunctionConfig {
    public boolean mutiSelect;
    protected int maxSize;
    private boolean camera;
    private boolean preview;
    private ArrayList<String> selectedList;

    public FunctionConfig(Builder builder) {
        this.mutiSelect = builder.mutiSelect;
        this.maxSize = builder.maxSize;
        this.camera = builder.camera;
        this.selectedList = builder.selectedList;
        this.preview = builder.preview;
    }

    public boolean isEnableMutiSelect() {
        return this.mutiSelect;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isEnableCamera() {
        return this.camera;
    }

    public boolean isEnablePreview() {
        return this.preview;
    }

    public ArrayList<String> getSelectedList() {
        return this.selectedList;
    }

    public static class Builder {
        private boolean mutiSelect;
        private int maxSize;
        private boolean camera;
        private boolean preview;
        private ArrayList<String> selectedList;

        public Builder setEnableMutiSelect(boolean mutiSelect) {
            this.mutiSelect = mutiSelect;
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder setEnableCamera(boolean enable) {
            this.camera = enable;
            return this;
        }

        public Builder setEnablePreview(boolean enable) {
            this.preview = enable;
            return this;
        }

        public Builder setSelected(ArrayList<String> selectedList) {
            if (selectedList != null) {
                this.selectedList = selectedList;
            }
            return this;
        }

        public FunctionConfig build() {
            return new FunctionConfig(this);
        }
    }
}

